/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class RewriteJoinAsCrossJoin
extends RQETransformation {
    public RewriteJoinAsCrossJoin() {
        this.mName = "Rewrite join as cross join.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{301011};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLJoin jNode = (SQLJoin)node;
        IXQEQueryNode filterNode = nodeFactory.createNode(301009);
        jNode.insertParent(filterNode);
        filterNode.addChild(jNode.getPredicate().detach());
        jNode.setJoinType(SQLJoin.SubType.CROSS);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLJoin jNode = (SQLJoin)node;
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = qBlock.getDataSource();
        boolean bl = status = dataSource != null && qBlock.isForeign() && dataSource.getCapabilities().isSupported("supports.join.inner.limitedThetaJoins") && jNode.getJoinType() == SQLJoin.SubType.INNER && !this.hasEquiJoin(jNode.getPredicate());
        if (status) {
            this.traceQueryCondition(status, "Join needs to be rewritten as cross join.", trace);
        } else {
            this.traceQueryCondition(status, "Join doesn't need to be rewritten as cross join.", trace);
        }
        return status;
    }

    private boolean hasEquiJoin(IXQEQueryNode predicate) {
        boolean result = false;
        if (predicate.getType() == 301027 && ((SQLLogical)predicate).getSubType() == SQLLogical.SubType.AND) {
            result = this.hasEquiJoin(predicate.getChild(0)) || this.hasEquiJoin(predicate.getChild(1));
        } else if (predicate.getType() == 301026 && ((SQLComparison)predicate).getSubType() == SQLComparison.SubType.EQUAL) {
            IXQEQueryNode left = predicate.getChild(0);
            IXQEQueryNode right = predicate.getChild(1);
            result = left.getType() == 301032 && right.getType() == 301032 && ((SQLFid)left).getSourceNo() != ((SQLFid)right).getSourceNo();
        }
        return result;
    }
}

