/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JoinGraph {
    private List<Vertex> nodes = new ArrayList<Vertex>();
    private List<Edge> edges = new ArrayList<Edge>();
    private Set<Vertex> settledNodes;
    private Set<Vertex> unSettledNodes;
    private Map<Vertex, Vertex> predecessors;
    private Map<Vertex, Integer> distance;

    public JoinGraph(List<Vertex> theNodes, List<Edge> theEdges) {
        this.nodes = theNodes;
        this.edges = theEdges;
    }

    public List<Vertex> getNodes() {
        return this.nodes;
    }

    public LinkedList<Vertex> getShortestPath(Vertex target) {
        LinkedList<Vertex> path = new LinkedList<Vertex>();
        Vertex step = target;
        if (this.predecessors.get(step) == null) {
            return null;
        }
        path.add(step);
        while (this.predecessors.get(step) != null) {
            step = this.predecessors.get(step);
            path.add(step);
        }
        Collections.reverse(path);
        return path;
    }

    public void applyDijkstraAlgorithm(Vertex source) {
        this.settledNodes = new HashSet<Vertex>();
        this.unSettledNodes = new HashSet<Vertex>();
        this.distance = new HashMap<Vertex, Integer>();
        this.predecessors = new HashMap<Vertex, Vertex>();
        this.distance.put(source, 0);
        this.unSettledNodes.add(source);
        while (this.unSettledNodes.size() > 0) {
            Vertex node = this.getMinimum(this.unSettledNodes);
            this.settledNodes.add(node);
            this.unSettledNodes.remove(node);
            this.findMinimalDistances(node);
        }
    }

    private void findMinimalDistances(Vertex node) {
        List<Vertex> adjacentNodes = this.getNeighbors(node);
        for (Vertex target : adjacentNodes) {
            if (this.getShortestDistance(target) <= this.getShortestDistance(node) + this.getDistance(node, target)) continue;
            this.distance.put(target, this.getShortestDistance(node) + this.getDistance(node, target));
            this.predecessors.put(target, node);
            this.unSettledNodes.add(target);
        }
    }

    private int getDistance(Vertex source, Vertex target) {
        for (Edge edge : this.edges) {
            if (!edge.getSourceNode().equals(source) || !edge.getTargetNode().equals(target)) continue;
            return edge.getWeight();
        }
        return -1;
    }

    private List<Vertex> getNeighbors(Vertex vertex) {
        ArrayList<Vertex> neighbors = new ArrayList<Vertex>();
        for (Edge edge : this.edges) {
            if (!edge.getSourceNode().equals(vertex) || this.isSettled(edge.getTargetNode())) continue;
            neighbors.add(edge.getTargetNode());
        }
        return neighbors;
    }

    private Vertex getMinimum(Set<Vertex> vertices) {
        Vertex minimum = null;
        for (Vertex vertex : vertices) {
            if (minimum == null) {
                minimum = vertex;
                continue;
            }
            if (this.getShortestDistance(vertex) >= this.getShortestDistance(minimum)) continue;
            minimum = vertex;
        }
        return minimum;
    }

    private boolean isSettled(Vertex node) {
        return this.settledNodes.contains(node);
    }

    private int getShortestDistance(Vertex target) {
        Integer d = this.distance.get(target);
        if (d == null) {
            return Integer.MAX_VALUE;
        }
        return d;
    }

    public static class Edge {
        private Vertex sourceNode;
        private Vertex targetNode;

        public Edge(Vertex theSourceNode, Vertex theTargetNode) {
            this.sourceNode = theSourceNode;
            this.targetNode = theTargetNode;
        }

        public Vertex getSourceNode() {
            return this.sourceNode;
        }

        public Vertex getTargetNode() {
            return this.targetNode;
        }

        public int getWeight() {
            return 1;
        }
    }

    public static class Vertex {
        private int sourceNo;

        public Vertex(int theSourceNo) {
            this.sourceNo = theSourceNo;
        }

        public int getSourceNo() {
            return this.sourceNo;
        }

        public int hashCode() {
            return this.sourceNo;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Vertex) {
                Vertex other = (Vertex)obj;
                return this.sourceNo == other.sourceNo;
            }
            return false;
        }
    }
}

