/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization.vqe;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.SQLValueDecoration;
import com.cognos.xqe.ast.qep.QEPGroupBy;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public final class VectorizeSQLGroupBy
extends RQETransformation {
    public VectorizeSQLGroupBy() {
        this.mName = "Vectorize a SQLGroupBy node.";
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
        this.mPassNumbers = new int[]{12};
        this.mTypes = new int[]{901020, 901021};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLValueList projectList = (SQLValueList)node.getChild(1);
        IXQEQueryNode sqlProject = nodeFactory.createNode(301015);
        node.insertParent(sqlProject);
        projectList.move(sqlProject);
        SQLValueList valueList = (SQLValueList)nodeFactory.createNode(301030);
        node.addChild(valueList, 1);
        SQLGroupByList groupByList = ((QEPGroupBy)node).getGroupByList();
        if (groupByList != null) {
            for (IXQEQueryNode gColumn : groupByList.getChildren()) {
                valueList.addChild(gColumn);
            }
        }
        List<IXQEQueryNode> fidList = projectList.getDescendantsOfTypeOrdered(301032, new int[]{301034, 301059});
        for (IXQEQueryNode fid : fidList) {
            SQLFid newFid = (SQLFid)nodeFactory.createNode(301032);
            newFid.setDataType(((SQLFid)fid).getDataType());
            fid.exchange(newFid);
            int columnNo = valueList.indexOf(fid);
            if (columnNo < 0) {
                columnNo = valueList.getNumberChildren();
                valueList.addChild(fid);
            }
            newFid.setVirtualColumnNo(columnNo);
        }
        List<IXQEQueryNode> aggrList = projectList.getDescendantsOfTypeOrdered(301034, false);
        for (IXQEQueryNode aggrNode : aggrList) {
            SQLFid fid = (SQLFid)nodeFactory.createNode(301032);
            fid.setVirtualColumnNo(valueList.getNumberChildren());
            fid.setDataType(((SQLQueryNode)aggrNode).getDataType());
            aggrNode.exchange(fid);
            valueList.addChild(aggrNode);
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLValueDecoration valueDecorationNode = (SQLValueDecoration)node.getAncestorOfType(601013);
        boolean bl = status = valueDecorationNode != null && valueDecorationNode.isVectorizedQueryExecutionEnabled();
        if (status) {
            this.traceQueryCondition(status, "Vectorized query execution is applicable.", trace);
        } else {
            this.traceQueryCondition(status, "Vectorized query execution is not applicable.", trace);
        }
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        SQLValueList valueList = (SQLValueList)node.getChild(1);
        boolean status = false;
        if (node.getType() != 301015 || valueList.hasWindowedAggregates()) {
            for (IXQEQueryNode exprNode : valueList.getChildren()) {
                if (exprNode.getType() == 301032 || exprNode.getType() == 301034) continue;
                status = true;
                break;
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Group By needs to be normalized.", trace);
        } else {
            this.traceQueryCondition(status, "Group By does not need to be normalized.", trace);
        }
        return status;
    }
}

