/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.optimization.vqe;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.XQEQueryNode;
import com.cognos.xqe.ast.localprocessing.SQLValueDecoration;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.preoptimization.SQLPreoptimizerUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;

public final class VectorizeSQLProject
extends RQETransformation {
    private static final String NORMALIZED = "Normalized";

    public VectorizeSQLProject() {
        this.mName = "Vectorize a SQLProject node.";
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
        this.mPassNumbers = new int[]{12};
        this.mTypes = new int[]{301015};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        IDataSource dataSource = null;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLValueList projectList = (SQLValueList)node.getChild(1);
        ArrayList<IXQEQueryNode> exprList = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode child : projectList.getChildren()) {
            this.getExpressions(child, exprList);
        }
        node.setPropertyValue(NORMALIZED, true);
        boolean notRequired = true;
        for (IXQEQueryNode child : exprList) {
            if (child.getType() == 301032) continue;
            notRequired = false;
            break;
        }
        if (!notRequired) {
            IXQEQueryNode[] pNode = nodeFactory.createNode(301015);
            node.getChild(0).insertParent((IXQEQueryNode)pNode);
            SQLValueList vList2 = SQLPreoptimizerUtil.buildProjection(environment, exprList, 0, 0, dataSource);
            pNode.addChild(vList2);
        }
        notRequired = true;
        for (IXQEQueryNode exprNode : projectList.getChildren()) {
            if (exprNode.getType() == 301032 || exprNode.getType() == 301034) continue;
            notRequired = false;
            break;
        }
        if (notRequired) {
            return;
        }
        IXQEQueryNode sqlProject = nodeFactory.createNode(301015);
        node.insertParent(sqlProject);
        projectList.move(sqlProject);
        SQLValueList valueList = (SQLValueList)nodeFactory.createNode(301030);
        node.addChild(valueList);
        List<IXQEQueryNode> fidList = projectList.getDescendantsOfTypeOrdered(301032, 301034);
        for (IXQEQueryNode fid : fidList) {
            int columnNo = valueList.indexOf(fid);
            if (columnNo < 0) {
                columnNo = valueList.getNumberChildren();
            }
            SQLFid newFid = (SQLFid)nodeFactory.createNode(301032);
            newFid.setVirtualColumnNo(columnNo);
            newFid.setDataType(((SQLFid)fid).getDataType());
            fid.exchange(newFid);
            valueList.addChild(fid);
        }
        List<IXQEQueryNode> aggrList = projectList.getDescendantsOfTypeOrdered(301034, false);
        for (IXQEQueryNode aggrNode : aggrList) {
            int columnNo = valueList.indexOf(aggrNode);
            if (columnNo < 0) {
                columnNo = valueList.getNumberChildren();
            }
            SQLFid newFid = (SQLFid)nodeFactory.createNode(301032);
            newFid.setVirtualColumnNo(valueList.getNumberChildren());
            newFid.setDataType(((SQLQueryNode)aggrNode).getDataType());
            aggrNode.exchange(newFid);
            valueList.addChild(aggrNode);
        }
    }

    private void getExpressions(IXQEQueryNode node, List<IXQEQueryNode> exprNodeList) {
        if (node.getType() == 301059) {
            return;
        }
        if ((((SQLQueryNode)node).isProjectable() || node.getType() == 301047) && !((SQLQueryNode)node).hasWindowedAggregates()) {
            exprNodeList.add(node);
        } else {
            for (IXQEQueryNode child : node.getChildren()) {
                this.getExpressions(child, exprNodeList);
            }
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLValueDecoration valueDecorationNode = (SQLValueDecoration)node.getAncestorOfType(601013);
        boolean bl = status = valueDecorationNode != null && valueDecorationNode.isVectorizedQueryExecutionEnabled();
        if (status) {
            this.traceQueryCondition(status, "Vectorized query execution is applicable.", trace);
        } else {
            this.traceQueryCondition(status, "Vectorized query execution is not applicable.", trace);
        }
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        SQLValueList valueList = (SQLValueList)node.getChild(1);
        boolean bl = status = (qBlock == null || !qBlock.isForeign()) && ((XQEQueryNode)node).getBooleanPropertyValue(NORMALIZED, false) == false && valueList.hasWindowedAggregates();
        if (status) {
            this.traceQueryCondition(status, "Projection needs to be vectorized.", trace);
        } else {
            this.traceQueryCondition(status, "Projection does not need to be vectorized.", trace);
        }
        return status;
    }
}

