/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.localprocessing.SQLValueDecoration;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.util.Governors;
import java.util.List;

public final class AdjustDataItemTypes
extends RQETransformation {
    public AdjustDataItemTypes() {
        this.mName = "Adjust data types.";
        this.mPassNumbers = new int[]{26};
        this.mTypes = new int[]{301004};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        boolean setIsNullable = reqEnv.getResolveIsNullable() && !reqEnv.isInternal();
        RSAPIDataset dataSet = (RSAPIDataset)node.getAncestorOfType(401005);
        boolean isDetailQuery = dataSet.isForDetailQuery();
        RSAPIEdge[] edges = dataSet.getEdges();
        if (node.getType() == 301004) {
            SQLQueryItemList queryItems = ((SQLQueryBlock)node).getQueryItemList();
            List<SQLAlias> aliasList = ((SQLValueDecoration)dataSet.getChild(0)).getAliasList();
            Governors governors = environment.getExecutionEnvironment().getGovernors();
            boolean reportAsDatasource = false;
            if (governors != null) {
                reportAsDatasource = governors.getReportAsDatasource();
            }
            for (int i = 0; i < queryItems.size(); ++i) {
                IDataType dt;
                SQLQueryItem qItem = (SQLQueryItem)queryItems.get(i);
                SQLAlias aliasNode = aliasList.get(i);
                if (aliasNode == null || (dt = qItem.getDataType()) == null && !setIsNullable) continue;
                Boolean bAdjust = qItem.getAdjustDataTypeFromResultSet();
                for (RSAPIEdge edge : edges) {
                    for (RSAPIEdgeRowset rowset : edge.getRowsets()) {
                        if (!rowset.getName().equals(aliasNode.getRowsetName())) continue;
                        RSAPIDataItem refDataItem = rowset.getRefDataItem();
                        if (refDataItem != null && refDataItem.getName().equals(aliasNode.getColumnName())) {
                            if (dt != null) {
                                refDataItem.setDataType(dt);
                            }
                            if (setIsNullable) {
                                refDataItem.setNullable(qItem.isNullable());
                            }
                            if (reportAsDatasource) {
                                refDataItem.setSqlColumnName(qItem.getName());
                                refDataItem.setSqlColumnIndex(qItem.getColumnNo());
                            }
                            if (bAdjust != Boolean.TRUE) continue;
                            refDataItem.setAdjustDataTypeFromResultSet(true);
                            continue;
                        }
                        for (RSAPIDataItem dataItem : rowset.getDataItems()) {
                            if (!dataItem.getName().equals(aliasNode.getColumnName())) continue;
                            if (dataItem.getModelReference() == null) {
                                dataItem.setModelReference(qItem.getModelReference());
                            }
                            if (!(dt == null || isDetailQuery && dt.isVariant() && this.isDatatypeDetermined(dataItem.getDataType()))) {
                                dataItem.setDataType(dt);
                            }
                            if (setIsNullable) {
                                dataItem.setNullable(qItem.isNullable());
                            }
                            if (reportAsDatasource) {
                                dataItem.setSqlColumnName(qItem.getName());
                                dataItem.setSqlColumnIndex(qItem.getColumnNo());
                            }
                            if (bAdjust != Boolean.TRUE || isDetailQuery && dt != null && dt.isVariant() && this.isDatatypeDetermined(dataItem.getDataType())) continue;
                            dataItem.setAdjustDataTypeFromResultSet(true);
                        }
                    }
                }
            }
        }
        node.setPropertyValue("adjustedDataItemTypes", Boolean.TRUE);
    }

    private boolean isDatatypeDetermined(IDataType dt) {
        if (dt == null || dt.isVariant()) {
            return false;
        }
        return !dt.isTextType() || dt.getLength() != -1;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        IXQEQueryNode parent = node.getParent();
        Boolean adjusted = ((SQLQueryBlock)node).getBooleanPropertyValue("adjustedDataItemTypes");
        boolean bl = status = parent.getType() == 601013 && (adjusted == null || adjusted == false);
        if (status) {
            RSAPIDataset dataSet = (RSAPIDataset)parent.getAncestorOfType(401005);
            boolean bl2 = status = ((SQLValueDecoration)dataSet.getChild(0)).getAliasList() != null;
        }
        if (status) {
            this.traceQueryCondition(status, "Data types need to be adjusted.", trace);
        } else {
            this.traceQueryCondition(status, "Data types don't need to be adjusted.", trace);
        }
        return status;
    }
}

