/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class ApplyComplementaryLaws
extends RQETransformation {
    public ApplyComplementaryLaws() {
        this.mName = "Apply boolean algebra complementary laws.";
        this.mPassNumbers = new int[]{8, 10};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
        this.mTypes = new int[]{301027};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLLogical.SubType subType = ((SQLLogical)node).getSubType();
        BooleanValue bValue = BooleanValue.TRUE;
        if (subType == SQLLogical.SubType.AND) {
            bValue = BooleanValue.FALSE;
        }
        SQLLiteral literal = (SQLLiteral)environment.getNodeFactory().createNode(301031);
        literal.setDataType(DataTypeFactory.getBooleanType());
        literal.setValue(bValue);
        node.exchange(literal);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        boolean bl = status = ((SQLLogical)node).getSubType() == SQLLogical.SubType.AND || ((SQLLogical)node).getSubType() == SQLLogical.SubType.OR;
        if (status) {
            boolean bl2 = status = dataSource == null || !dataSource.isRelational() || dataSource.getCapabilities().isSupported("performance.transitiveClosure") || dataSource.getCapabilities().isSupported("performance.predicatePushdown") || !node.isSupported(dataSource);
        }
        if (status) {
            status = node.getChild(0).getType() == 301027 && ((SQLLogical)node.getChild(0)).getSubType() == SQLLogical.SubType.NOT ? node.getChild(1).isSameExpression(node.getChild(0).getChild(0), false) : (node.getChild(1).getType() == 301027 && ((SQLLogical)node.getChild(1)).getSubType() == SQLLogical.SubType.NOT ? node.getChild(0).isSameExpression(node.getChild(1).getChild(0), false) : false);
        }
        if (status) {
            this.traceNodeCondition(false, "Boolean algebra complementarity laws can be applied.", trace);
        } else {
            this.traceNodeCondition(false, "Boolean algebra complementarity laws cannot be applied.", trace);
        }
        return status;
    }
}

