/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;

public final class ApplyContradictionLaws
extends RQETransformation {
    public ApplyContradictionLaws() {
        this.mName = "Apply boolean algebra contradiction laws.";
        this.mPassNumbers = new int[]{8, 10};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
        this.mTypes = new int[]{301027};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLLiteral literal = (SQLLiteral)environment.getNodeFactory().createNode(301031);
        literal.setDataType(DataTypeFactory.getBooleanType());
        literal.setValue(BooleanValue.FALSE);
        node.exchange(literal);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        boolean bl = status = dataSource == null || !dataSource.isRelational() || dataSource.getCapabilities().isSupported("performance.transitiveClosure") || dataSource.getCapabilities().isSupported("performance.predicatePushdown") || !node.isSupported(dataSource);
        if (status) {
            status = false;
            SQLLogical.SubType subType = ((SQLLogical)node).getSubType();
            if (subType == SQLLogical.SubType.AND && (node.getParent().getType() == 301009 || node.getParent().getType() == 301027 && ((SQLLogical)node.getParent()).getSubType() == SQLLogical.SubType.OR)) {
                List<IXQEQueryNode> exprNodes = this.getApplicableNodes(subType, node, new ArrayList<IXQEQueryNode>());
                for (int i = 0; i < exprNodes.size() && !status; ++i) {
                    IXQEQueryNode lChild = exprNodes.get(i);
                    block9: for (int j = i + 1; j < exprNodes.size() && !status; ++j) {
                        IXQEQueryNode rChild = exprNodes.get(j);
                        if (!lChild.getChild(0).isSameExpression(rChild.getChild(0), false) || !lChild.getChild(1).isSameExpression(rChild.getChild(1), false)) continue;
                        SQLComparison.SubType lSubType = ((SQLComparison)lChild).getSubType();
                        SQLComparison.SubType rSubType = ((SQLComparison)rChild).getSubType();
                        switch (lSubType) {
                            case EQUAL: {
                                status = rSubType == SQLComparison.SubType.NOTEQUAL;
                                continue block9;
                            }
                            case NOTEQUAL: {
                                status = rSubType == SQLComparison.SubType.EQUAL;
                                continue block9;
                            }
                            case LESS: {
                                status = rSubType == SQLComparison.SubType.GREATEREQUAL;
                                continue block9;
                            }
                            case LESSEQUAL: {
                                status = rSubType == SQLComparison.SubType.GREATER || rSubType == SQLComparison.SubType.GREATEREQUAL;
                                continue block9;
                            }
                            case GREATER: {
                                status = rSubType == SQLComparison.SubType.LESSEQUAL;
                                continue block9;
                            }
                            case GREATEREQUAL: {
                                status = rSubType == SQLComparison.SubType.LESS || rSubType == SQLComparison.SubType.LESSEQUAL;
                                continue block9;
                            }
                            default: {
                                status = false;
                            }
                        }
                    }
                }
            }
        }
        if (status) {
            this.traceNodeCondition(false, "Boolean algebra contradiction law can be applied.", trace);
        } else {
            this.traceNodeCondition(false, "Boolean algebra contradiction law cannot be applied.", trace);
        }
        return status;
    }

    private List<IXQEQueryNode> getApplicableNodes(SQLLogical.SubType subType, IXQEQueryNode child, List<IXQEQueryNode> list) {
        if (child.getType() == 301026) {
            list.add(child);
        } else if (child.getType() == 301027 && ((SQLLogical)child).getSubType() == SQLLogical.SubType.AND) {
            this.getApplicableNodes(subType, child.getChild(0), list);
            this.getApplicableNodes(subType, child.getChild(1), list);
        }
        return list;
    }
}

