/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ApplyIdempotentLaws
extends RQETransformation {
    public ApplyIdempotentLaws() {
        this.mName = "Apply boolean algebra idempotency laws.";
        this.mPassNumbers = new int[]{8, 10};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
        this.mTypes = new int[]{301027};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLLogical.SubType subType = ((SQLLogical)node).getSubType();
        List<IXQEQueryNode> lExprNodes = this.getApplicableNodes(subType, node.getChild(0), new ArrayList<IXQEQueryNode>());
        List<IXQEQueryNode> rExprNodes = this.getApplicableNodes(subType, node.getChild(1), new ArrayList<IXQEQueryNode>());
        for (int i = 0; i < lExprNodes.size(); ++i) {
            Iterator<IXQEQueryNode> it = rExprNodes.iterator();
            while (it.hasNext()) {
                IXQEQueryNode rExprNode;
                IXQEQueryNode lExprNode = lExprNodes.get(i);
                if (!lExprNode.isSameExpression(rExprNode = it.next(), false)) continue;
                IXQEQueryNode parent = rExprNode.getParent();
                rExprNode.detach();
                parent.extract();
                it.remove();
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        boolean bl = status = dataSource == null || !dataSource.isRelational() || dataSource.getCapabilities().isSupported("performance.transitiveClosure") || dataSource.getCapabilities().isSupported("performance.predicatePushdown") || !node.isSupported(dataSource);
        if (status) {
            status = false;
            SQLLogical.SubType subType = ((SQLLogical)node).getSubType();
            if (subType == SQLLogical.SubType.AND || subType == SQLLogical.SubType.OR) {
                IXQEQueryNode lChild = node.getChild(0);
                IXQEQueryNode rChild = node.getChild(1);
                List<IXQEQueryNode> lExprNodes = this.getApplicableNodes(subType, lChild, new ArrayList<IXQEQueryNode>());
                List<IXQEQueryNode> rExprNodes = this.getApplicableNodes(subType, rChild, new ArrayList<IXQEQueryNode>());
                for (int i = 0; i < lExprNodes.size() && !status; ++i) {
                    for (int j = 0; j < rExprNodes.size() && !status; ++j) {
                        status = lExprNodes.get(i).isSameExpression(rExprNodes.get(j), false);
                    }
                }
            }
        }
        if (status) {
            this.traceNodeCondition(false, "Boolean algebra idempotency law can be applied.", trace);
        } else {
            this.traceNodeCondition(false, "Boolean algebra idempotency law cannot be applied.", trace);
        }
        return status;
    }

    private List<IXQEQueryNode> getApplicableNodes(SQLLogical.SubType subType, IXQEQueryNode child, List<IXQEQueryNode> list) {
        if (child.getType() != 301027 || ((SQLLogical)child).getSubType() != subType) {
            list.add(child);
        } else {
            this.getApplicableNodes(subType, child.getChild(0), list);
            this.getApplicableNodes(subType, child.getChild(1), list);
        }
        return list;
    }
}

