/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class ApplyIntersectionLaws
extends RQETransformation {
    public ApplyIntersectionLaws() {
        this.mName = "Apply boolean algebra intersection laws.";
        this.mPassNumbers = new int[]{8, 10};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
        this.mTypes = new int[]{301027};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        IXQEQueryNode lChild = node.getChild(0);
        IXQEQueryNode rChild = node.getChild(1);
        if (lChild.getType() == 301031) {
            BooleanValue value = (BooleanValue)((SQLLiteral)lChild).getValue();
            if (value.getBoolean()) {
                lChild.detach();
            } else {
                rChild.detach();
            }
        } else {
            BooleanValue value = (BooleanValue)((SQLLiteral)rChild).getValue();
            if (value.getBoolean()) {
                rChild.detach();
            } else {
                lChild.detach();
            }
        }
        ((SQLQueryNode)node).invalidateSupportCache();
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (((SQLLogical)node).getSubType() == SQLLogical.SubType.AND) {
            IXQEQueryNode lChild = node.getChild(0);
            IXQEQueryNode rChild = node.getChild(1);
            if (lChild.getType() == 301031 && ((SQLLiteral)lChild).getDataType().getCCLTypeCode() == 51 || rChild.getType() == 301031 && ((SQLLiteral)rChild).getDataType().getCCLTypeCode() == 51) {
                status = true;
            }
        }
        if (status) {
            this.traceNodeCondition(false, "Boolean algebra intersection law can be applied.", trace);
        } else {
            this.traceNodeCondition(false, "Boolean algebra intersection law cannot be applied.", trace);
        }
        return status;
    }
}

