/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;

public final class ApplyRedundancyLaws
extends RQETransformation {
    public ApplyRedundancyLaws() {
        this.mName = "Apply boolean algebra redundancy laws.";
        this.mPassNumbers = new int[]{8, 10};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
        this.mTypes = new int[]{301027};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        SQLLogical lChild = (SQLLogical)node.getChild(0);
        SQLLogical rChild = (SQLLogical)node.getChild(1);
        List<IXQEQueryNode> lExprNodes = this.getApplicableNodes(lChild, new ArrayList<IXQEQueryNode>());
        List<IXQEQueryNode> rExprNodes = this.getApplicableNodes(rChild, new ArrayList<IXQEQueryNode>());
        IXQEQueryNode predicate = node;
        for (int i = 0; i < lExprNodes.size(); ++i) {
            for (int j = 0; j < rExprNodes.size(); ++j) {
                IXQEQueryNode rExprNode;
                IXQEQueryNode lExprNode = lExprNodes.get(i);
                if (!lExprNode.isSameExpression(rExprNode = rExprNodes.get(j), false)) continue;
                IXQEQueryNode parent = lExprNode.getParent();
                lExprNode.detach();
                parent.extract();
                parent = rExprNode.getParent();
                rExprNode.detach();
                parent.extract();
                SQLLogical andNode = (SQLLogical)factory.createNode(301027);
                andNode.setSubType(SQLLogical.SubType.AND);
                andNode.addChild(lExprNode);
                predicate.insertParent(andNode);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLLogical.SubType subType = ((SQLLogical)node).getSubType();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        boolean bl = status = subType == SQLLogical.SubType.OR && (dataSource == null || !dataSource.isRelational() || dataSource.getCapabilities().isSupported("performance.transitiveClosure") || dataSource.getCapabilities().isSupported("performance.predicatePushdown") || !node.isSupported(dataSource));
        if (status) {
            status = false;
            IXQEQueryNode lChild = node.getChild(0);
            IXQEQueryNode rChild = node.getChild(1);
            if (lChild.getType() == 301027 && ((SQLLogical)lChild).getSubType() == SQLLogical.SubType.AND && rChild.getType() == 301027 && ((SQLLogical)rChild).getSubType() == SQLLogical.SubType.AND) {
                List<IXQEQueryNode> lExprNodes = this.getApplicableNodes(lChild, new ArrayList<IXQEQueryNode>());
                List<IXQEQueryNode> rExprNodes = this.getApplicableNodes(rChild, new ArrayList<IXQEQueryNode>());
                for (int i = 0; i < lExprNodes.size() && !status; ++i) {
                    for (int j = 0; j < rExprNodes.size() && !status; ++j) {
                        status = lExprNodes.get(i).isSameExpression(rExprNodes.get(j), false);
                    }
                }
            }
        }
        if (status) {
            this.traceNodeCondition(false, "Boolean algebra redundancy laws can be applied.", trace);
        } else {
            this.traceNodeCondition(false, "Boolean algebra redundancy laws cannot be applied.", trace);
        }
        return status;
    }

    private List<IXQEQueryNode> getApplicableNodes(IXQEQueryNode child, List<IXQEQueryNode> list) {
        if (child.getType() != 301027 || ((SQLLogical)child).getSubType() != SQLLogical.SubType.AND) {
            list.add(child);
        } else {
            this.getApplicableNodes(child.getChild(0), list);
            this.getApplicableNodes(child.getChild(1), list);
        }
        return list;
    }
}

