/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import com.cognos.xqe.transformation.relational.optimization.util.FactorAnalyzer;
import java.util.ArrayList;

public class BuildPredicateTransitiveClosure
extends RQETransformation {
    public BuildPredicateTransitiveClosure() {
        this.mName = "Build predicate transitive closure.";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{301014, 301011};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        SQLJoin.SubType jType = SQLJoin.SubType.INNER;
        if (node.getType() == 301011) {
            jType = ((SQLJoin)node).getJoinType();
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        ArrayList<EJFactor> equiJoinFactors = new ArrayList<EJFactor>();
        ArrayList<SFactor> simpleFactors = new ArrayList<SFactor>();
        IXQEQueryNode parent = node.getParent();
        while (parent.getType() == 301009) {
            SQLFilter factor = (SQLFilter)parent;
            SQLExpression predicate = factor.getPredicate();
            FactorAnalyzer.FactorType fType = factor.getFactorType();
            if (fType == FactorAnalyzer.FactorType.EQUIJOIN) {
                equiJoinFactors.add(new EJFactor(predicate.getChild(0), predicate.getChild(1)));
                equiJoinFactors.add(new EJFactor(predicate.getChild(1), predicate.getChild(0)));
            } else if (!(fType != FactorAnalyzer.FactorType.EQUIEXPRESSION && fType != FactorAnalyzer.FactorType.LESSEXPRESSION && fType != FactorAnalyzer.FactorType.GREATEREXPRESSION || predicate.getChild(0).getType() != 301031 && predicate.getChild(1).getType() != 301031)) {
                simpleFactors.add(new SFactor(factor));
            }
            parent = parent.getParent();
        }
        block1: for (int i = 0; i < simpleFactors.size(); ++i) {
            SFactor sFactor = (SFactor)simpleFactors.get(i);
            for (EJFactor ejFactor : equiJoinFactors) {
                if (sFactor.getSourceNo() != ejFactor.getLeftSourceNo() || sFactor.getVirtualColumnNo() != ejFactor.getLeftVirtualColumnNo()) continue;
                boolean found = false;
                for (int j = 0; j < simpleFactors.size(); ++j) {
                    SFactor sFactor2 = (SFactor)simpleFactors.get(j);
                    if (sFactor2.getFactorType() != sFactor.getFactorType() || sFactor2.getSourceNo() != ejFactor.getRightSourceNo() || sFactor2.getVirtualColumnNo() != ejFactor.getRightVirtualColumnNo() || !sFactor2.getOtherSide().isSameExpression(sFactor.getOtherSide(), false)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                SQLFid fid = (SQLFid)nodeFactory.copyNode(ejFactor.getRightFid());
                IXQEQueryNode eNode = nodeFactory.copyNode(sFactor.getOtherSide());
                SQLComparison predicate = (SQLComparison)nodeFactory.createNode(301026);
                predicate.setSubType(sFactor.getSubType());
                if (sFactor.getFIDPosition() == 0) {
                    predicate.addChild(fid);
                    predicate.addChild(eNode);
                } else {
                    predicate.addChild(eNode);
                    predicate.addChild(fid);
                }
                SQLFilter factor = (SQLFilter)nodeFactory.createNode(301009);
                node.insertParent(factor);
                factor.addChild(predicate);
                factor.setSubType(0);
                FactorAnalyzer.analyze(factor);
                if (factor.getSubType() == 301009) {
                    BitMask incidence = new BitMask();
                    if (jType == SQLJoin.SubType.LEFT_OUTER) {
                        incidence.set(0);
                    } else if (jType == SQLJoin.SubType.RIGHT_OUTER) {
                        incidence.set(1);
                    }
                    if (jType != SQLJoin.SubType.INNER && (jType == SQLJoin.SubType.FULL_OUTER || !factor.getIncidence().land(incidence).equals(factor.getIncidence()))) continue block1;
                }
                simpleFactors.add(new SFactor(factor));
            }
        }
        qBlock.setAppliedTransitiveClosure();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = qBlock.getDataSource();
        boolean forceTransitiveClosure = dataSource != null && dataSource.getCapabilities().isSupported("performance.transitiveClosure");
        boolean bl = status = (!qBlock.isForeign() || forceTransitiveClosure) && !qBlock.appliedTransitiveClosure() && node.getParent().getType() == 301009 && ((SQLFilter)node.getParent()).getFactorType() != null;
        if (status) {
            super.traceQueryCondition(status, "Predicate transitive closure can be applied.", trace);
        } else {
            super.traceQueryCondition(status, "Predicate transitive closure cannot be applied.", trace);
        }
        return status;
    }

    private class EJFactor {
        private SQLFid leftFid;
        private SQLFid rightFid;

        EJFactor(IXQEQueryNode lFid, IXQEQueryNode rFid) {
            this.leftFid = (SQLFid)lFid;
            this.rightFid = (SQLFid)rFid;
        }

        public int getLeftSourceNo() {
            return this.leftFid.getSourceNo();
        }

        public int getLeftVirtualColumnNo() {
            return this.leftFid.getVirtualColumnNo();
        }

        public int getRightSourceNo() {
            return this.rightFid.getSourceNo();
        }

        public int getRightVirtualColumnNo() {
            return this.rightFid.getVirtualColumnNo();
        }

        public SQLFid getRightFid() {
            return this.rightFid;
        }
    }

    private final class SFactor {
        private SQLFilter factor;
        private SQLComparison predicate;
        private SQLFid fid;
        private SQLQueryNode otherSide;
        private int fidPosition = 0;

        SFactor(SQLFilter theFactor) {
            this.factor = theFactor;
            this.predicate = (SQLComparison)this.factor.getPredicate();
            if (this.predicate.getChild(0).getType() == 301032) {
                this.fid = (SQLFid)this.predicate.getChild(0);
                this.otherSide = (SQLQueryNode)this.predicate.getChild(1);
            } else {
                this.fidPosition = 1;
                this.fid = (SQLFid)this.predicate.getChild(1);
                this.otherSide = (SQLQueryNode)this.predicate.getChild(0);
            }
        }

        public int getFIDPosition() {
            return this.fidPosition;
        }

        public int getSourceNo() {
            return this.fid.getSourceNo();
        }

        public int getVirtualColumnNo() {
            return this.fid.getVirtualColumnNo();
        }

        public FactorAnalyzer.FactorType getFactorType() {
            return this.factor.getFactorType();
        }

        public SQLQueryNode getOtherSide() {
            return this.otherSide;
        }

        public SQLComparison.SubType getSubType() {
            return this.predicate.getSubType();
        }
    }
}

