/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class CollapseNestedCaseExpressionInThenClause
extends RQETransformation {
    public CollapseNestedCaseExpressionInThenClause() {
        this.mName = "Collapse a nested CASE expression.";
        this.mPassNumbers = new int[]{0};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mTypes = new int[]{301074};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode parentWhenNode = node.getParent();
        IXQEQueryNode whenNode = node.getChild(0).getChild(0);
        SQLLogical logicalNode = (SQLLogical)factory.createNode(301027);
        logicalNode.setSubType(SQLLogical.SubType.AND);
        whenNode.getChild(0).insertParent(logicalNode);
        logicalNode.addChild(parentWhenNode.detachChild(0), 0);
        parentWhenNode.getGrandParent().exchange(node.detach());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        IXQEQueryNode parent = node.getParent();
        boolean bl = status = parent.getType() == 301048 && parent.getPositionOfChild(node) == 1;
        if (status) {
            IXQEQueryNode parentWhenList = parent.getParent();
            IXQEQueryNode whenList = node.getChild(0);
            boolean bl2 = status = parentWhenList.getNumberChildren() == 1 && whenList.getNumberChildren() == 1;
            if (status) {
                IXQEQueryNode parentCaseExpr = parent.getGrandParent();
                IXQEQueryNode elseExpr1 = null;
                IXQEQueryNode elseExpr2 = null;
                if (parentCaseExpr.getNumberChildren() == 2) {
                    elseExpr1 = parentCaseExpr.getChild(1);
                }
                if (node.getNumberChildren() == 2) {
                    elseExpr2 = node.getChild(1);
                }
                if (elseExpr1 != null || elseExpr2 != null) {
                    status = elseExpr1 == null ? elseExpr2.getType() == 301050 : (elseExpr2 == null ? elseExpr1.getType() == 301050 : elseExpr1.isSameExpression(elseExpr2, false));
                }
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Nested CASE expression can be collapsed.", trace);
        } else {
            this.traceQueryCondition(status, "Nested CASE expression cannot be collapsed.", trace);
        }
        return status;
    }
}

