/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public final class CollapseSQLQueryBlock
extends RQETransformation {
    public CollapseSQLQueryBlock(int[] passNumber) {
        this.mName = "Collapse a SQLQueryBlock node.";
        this.mPassNumbers = passNumber;
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mTypes = new int[]{301004};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        IXQEQueryNode parent = node.getParent();
        if (node.getChild(0).getType() == 301008) {
            IXQEQueryNode child = node.getChild(0).getChild(0);
            if (child.getType() != 301004) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "child.getType() != SQLNodeTypeEnum.SQLQUERYBLOCK");
            }
            if ((child = child.getChild(0)).getType() != 301008) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "child.getType() != SQLNodeTypeEnum.SQLDISTINCT");
            }
            node.getChild(0).extract();
            node.extract();
        } else {
            SQLQueryItemList itemList;
            SQLValueList vList2;
            SQLValueList vList1 = (SQLValueList)node.getChild(0).detachSecondChild();
            node.getChild(0).extract();
            SQLQueryBlock qBlock = (SQLQueryBlock)node.getChild(0);
            SQLQueryBlock delBlock = (SQLQueryBlock)node.extract();
            qBlock.setName(delBlock.getName());
            if (delBlock.getDataSource() != null) {
                qBlock.setDataSource(delBlock.getDataSource());
            }
            if (delBlock.getQueryItemList() != null && qBlock.getQueryItemList() == null) {
                qBlock.setQueryItemList(delBlock.getQueryItemList());
            }
            if ((vList2 = ((SQLQueryNode)qBlock.getChild(0)).getOutputList()) != null) {
                List<SQLAlias> aliasList1 = vList1.getAliasList();
                List<SQLAlias> aliasList2 = vList2.getAliasList();
                if (aliasList2 == null) {
                    vList2.setAliasList(aliasList1);
                } else if (aliasList1 != null) {
                    for (int i = 0; i < aliasList1.size(); ++i) {
                        SQLAlias alias = aliasList1.get(i);
                        if (alias == null) continue;
                        aliasList2.set(i, alias);
                    }
                }
                SQLQueryItemList itemList2 = qBlock.getQueryItemList();
                List<SQLAlias> aliasList = vList2.getAliasList();
                if (itemList2 != null && aliasList != null) {
                    for (int i = 0; i < itemList2.size(); ++i) {
                        SQLAlias alias = aliasList.get(i);
                        if (alias == null) continue;
                        ((SQLQueryItem)itemList2.get(i)).setName(alias.getName());
                    }
                }
                if (qBlock.getBlockType() == 301019) {
                    List<IXQEQueryNode> fidList = qBlock.getDescendantsOfTypeOrdered(301032, 301004);
                    for (int i = 0; i < fidList.size(); ++i) {
                        SQLFid fid = (SQLFid)fidList.get(i);
                        fid.setName(vList2.getName(fid.getVirtualColumnNo()));
                    }
                }
            } else if (parent.getType() == 301019 && qBlock.getBlockType() == 301012 && (itemList = qBlock.getQueryItemList()) != null) {
                List<IXQEQueryNode> fidList = parent.getDescendantsOfTypeOrdered(301032, 301004);
                SQLQueryBlock pQBlock = (SQLQueryBlock)parent.getParent();
                SQLQueryItemList pItemList = pQBlock.getQueryItemList();
                for (int i = 0; i < fidList.size(); ++i) {
                    SQLFid fid = (SQLFid)fidList.get(i);
                    SQLQueryItem item = (SQLQueryItem)itemList.get(fid.getVirtualColumnNo());
                    fid.setName(item.getName());
                    SQLQueryItem pItem = (SQLQueryItem)pItemList.get(i);
                    pItem.setName(item.getName());
                }
            }
        }
        if (parent.getType() == 601013 || parent.getType() == 301059) {
            SQLQueryBlock qBlock = (SQLQueryBlock)parent.getChild(0);
            qBlock.removeProperty("name");
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = true;
        SQLQueryBlock qBlock = (SQLQueryBlock)node;
        IXQEQueryNode parent = node.getParent();
        if (qBlock.getName() != null) {
            status = false;
        } else if (parent.getType() == 301008) {
            IXQEQueryNode nextParent = parent.getParent();
            if (nextParent.getType() == 301004 && ((SQLQueryBlock)nextParent).getName() != null) {
                status = false;
            }
        } else if (parent.getType() == 301018) {
            status = false;
        }
        if (status) {
            IXQEQueryNode nextChild;
            status = false;
            IXQEQueryNode child = node.getChild(0);
            if (child.getType() == 301015 && ((SQLProject)child).isCollapsible()) {
                IXQEQueryNode vList2;
                int nColumns;
                IXQEQueryNode nextChild2 = child.getChild(0);
                if (nextChild2.getType() == 301004 && ((SQLQueryBlock)nextChild2).getReusableQuery() == null && (nextChild2 = nextChild2.getChild(0)).getType() != 301016 && nextChild2.getType() != 301039 && nextChild2.getType() != 301038 && nextChild2.getType() != 301092 && nextChild2.getType() != 301012 && (nextChild2.getType() != 301018 && nextChild2.getType() != 301022 || node.getParent().getType() != 301008) && (nColumns = ((SQLQueryNode)nextChild2).getNumberColumns()) > 0 && (vList2 = child.getChild(1)).getNumberChildren() == nColumns) {
                    status = true;
                    for (int i = 0; i < vList2.getNumberChildren(); ++i) {
                        IXQEQueryNode exprNode = vList2.getChild(i);
                        if (exprNode.getType() == 301032 && ((SQLFid)exprNode).getVirtualColumnNo() == i && !((SQLFid)exprNode).isFieldRef()) continue;
                        status = false;
                        break;
                    }
                }
            } else if (child.getType() == 301008 && (nextChild = child.getChild(0)).getType() == 301004 && ((SQLQueryBlock)nextChild).getReusableQuery() == null && (nextChild = nextChild.getChild(0)).getType() == 301008) {
                status = true;
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Query block can be collapsed.", trace);
        } else {
            this.traceQueryCondition(status, "Query block cannot be collapsed.", trace);
        }
        return status;
    }
}

