/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLQuantifier;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class ConvertAllPredicate
extends RQETransformation {
    public ConvertAllPredicate() {
        this.mName = "Convert a '<> ALL' predicate node.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301026};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode inNode = factory.createNode(301076);
        SQLComparison comparison = (SQLComparison)node;
        SQLQuantifier quantifier = (SQLQuantifier)comparison.getChild(1);
        quantifier.extract();
        comparison.exchange(inNode, true);
        SQLLogical notNode = (SQLLogical)factory.createNode(301027);
        notNode.setSubType(SQLLogical.SubType.NOT);
        inNode.insertParent(notNode);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        SQLComparison comparison = (SQLComparison)node;
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        boolean status = false;
        IXQEQueryNode child = comparison.getChild(1);
        if (comparison.getSubType() == SQLComparison.SubType.NOTEQUAL) {
            boolean bl = status = child.getType() == 301055 && ((SQLQuantifier)child).getSubType() == SQLQuantifier.SubType.ALL;
        }
        if (dataSource != null && status) {
            boolean bl = status = !comparison.isSupported(dataSource) || !pQueryBlock.isForeign();
        }
        if (status) {
            this.traceQueryCondition(status, "IN expression is not supported.", trace);
        } else {
            this.traceQueryCondition(status, "IN expression is supported.", trace);
        }
        return status;
    }
}

