/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.Collection;

public final class ConvertCrossJoinToProduct
extends RQETransformation {
    public ConvertCrossJoinToProduct() {
        this.mName = "Convert the CROSS JOIN node to a product node.";
        this.mPassNumbers = new int[]{3};
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
        this.mTypes = new int[]{301011};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode product = nodeFactory.createNode(301014);
        node.exchange(product, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLJoin joinNode = (SQLJoin)node;
        boolean bl = status = joinNode.getJoinType() == SQLJoin.SubType.CROSS;
        if (status) {
            SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
            Collection<IDataSource> dataSources = pQueryBlock.getDataSourceList();
            IDataSource dataSource = pQueryBlock.getDataSource();
            boolean bl2 = status = dataSource == null || dataSources.size() > 1 || !joinNode.isSupported(dataSource);
        }
        if (status) {
            this.traceQueryCondition(status, "CROSS JOIN node needs to be converted to a product node.", trace);
        } else {
            this.traceQueryCondition(status, "CROSS JOIN node doesn't need to be converted to a product node.", trace);
        }
        return status;
    }
}

