/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLCast;
import com.cognos.xqe.ast.sql.SQLDataType;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueExpression;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class ConvertDatePlusTimeToCompatibleSQL
extends RQETransformation {
    private static final int TIME_AS_CHAR_LENGTH = 24;
    private static final int DATE_AS_CHAR_LENGTH = 11;

    public ConvertDatePlusTimeToCompatibleSQL() {
        this.mName = "convert date plus time to Standard SQL";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301025};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = ((SQLValueExpression)node).getSubType() == SQLValueExpression.SubType.ADD && (((SQLQueryNode)node.getChild(0)).getDataType().isDate() && ((SQLQueryNode)node.getChild(1)).getDataType().isTime() || ((SQLQueryNode)node.getChild(0)).getDataType().isTime() && ((SQLQueryNode)node.getChild(1)).getDataType().isDate());
        if (status) {
            this.traceQueryCondition(status, "Expression needs to be converted.", trace);
        } else {
            this.traceQueryCondition(status, "Expression does not need to be converted.", trace);
        }
        return status;
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        if (((SQLQueryNode)node.getChild(0)).getDataType().isTime()) {
            node.getChild(0).move(node, 1);
        }
        SQLCast castNode = (SQLCast)factory.createNode(301047);
        node.insertParent(castNode);
        SQLDataType targetType = (SQLDataType)factory.createNode(301037);
        if (((SQLQueryNode)node.getChild(1)).getDataType().getCCLTypeCode() == 52) {
            targetType.setDataType(DataTypeFactory.getTimestampWithTZType());
        } else {
            targetType.setDataType(DataTypeFactory.getTimestampType());
        }
        castNode.addChild(targetType);
        SQLValueExpression val = (SQLValueExpression)node;
        val.setFunctionName(SQLValueExpression.SubType.CONCATENATE.name());
        val.setSubType(SQLValueExpression.SubType.CONCATENATE);
        castNode = (SQLCast)factory.createNode(301047);
        node.getChild(0).insertParent(castNode);
        targetType = (SQLDataType)factory.createNode(301037);
        targetType.setDataType(DataTypeFactory.getCharType(11));
        castNode.addChild(targetType);
        castNode = (SQLCast)factory.createNode(301047);
        node.getChild(1).insertParent(castNode);
        targetType = (SQLDataType)factory.createNode(301037);
        targetType.setDataType(DataTypeFactory.getVarcharType(24));
        castNode.addChild(targetType);
        ((SQLQueryNode)node).invalidateSupportCache();
    }
}

