/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLCast;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueExpression;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntervalQualifier;
import com.cognos.xqe.data.types.IntervalType;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import java.util.HashMap;
import java.util.Map;

public class ConvertDateTimeAndIntervalCastExpression
extends RQETransformation {
    private static final Map<IntervalQualifier, String> FUNCTION_NAMES = new HashMap<IntervalQualifier, String>();

    public ConvertDateTimeAndIntervalCastExpression() {
        this.mName = "Convert date/time and interval cast expression to a predefined function.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301025};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLQueryNode leftNode = (SQLQueryNode)node.getChild(0);
        if (leftNode.getDataType().getSubType() != DataSubType.DATETIMETYPE) {
            node.addChild(node.detachChild(0));
        }
        SQLCast castNode = (SQLCast)node.getChild(1);
        SQLFunction functionNode = (SQLFunction)nodeFactory.createNode(301033);
        IntervalType intervalType = (IntervalType)castNode.getDataType();
        switch (intervalType.getQualifier()) {
            case INTERVAL_YEAR: {
                functionNode.setSubType(SQLFunction.SubType.ADD_YEARS);
                break;
            }
            case INTERVAL_MONTH: {
                functionNode.setSubType(SQLFunction.SubType.ADD_MONTHS);
                break;
            }
            case INTERVAL_DAY: {
                functionNode.setSubType(SQLFunction.SubType.ADD_DAYS);
                break;
            }
            case INTERVAL_HOUR: {
                functionNode.setSubType(SQLFunction.SubType.ADD_HOURS);
                break;
            }
            case INTERVAL_MINUTE: {
                functionNode.setSubType(SQLFunction.SubType.ADD_MINUTES);
                break;
            }
            case INTERVAL_SECOND: {
                functionNode.setSubType(SQLFunction.SubType.ADD_SECONDS);
                break;
            }
        }
        functionNode.setFunctionName(FUNCTION_NAMES.get((Object)intervalType.getQualifier()));
        node.exchange(functionNode, true);
        if (((SQLValueExpression)node).getSubType() == SQLValueExpression.SubType.SUBTRACT) {
            IXQEQueryNode iExprNode = functionNode.getChild(1).getChild(0);
            if (iExprNode.getType() != 301025 || ((SQLValueExpression)iExprNode).getSubType() != SQLValueExpression.SubType.NEGATE) {
                SQLValueExpression vExprNode = (SQLValueExpression)nodeFactory.createNode(301025);
                vExprNode.setSubType(SQLValueExpression.SubType.NEGATE);
                iExprNode.insertParent(vExprNode);
            } else if (iExprNode.getType() == 301025 && ((SQLValueExpression)iExprNode).getSubType() == SQLValueExpression.SubType.NEGATE) {
                iExprNode.extract();
            }
        }
        castNode.getChild(1).extract();
        castNode.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        SQLValueExpression sqlNode = (SQLValueExpression)node;
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        boolean status = false;
        if (dataSource != null && dataSource.isRelational()) {
            IDataSourceCapabilities capabilities = dataSource.getCapabilities();
            boolean bl = status = sqlNode.getSubType() == SQLValueExpression.SubType.ADD || sqlNode.getSubType() == SQLValueExpression.SubType.SUBTRACT;
            if (status) {
                SQLQueryNode leftNode = (SQLQueryNode)sqlNode.getChild(0);
                SQLQueryNode rightNode = (SQLQueryNode)sqlNode.getChild(1);
                if (leftNode.getDataType().getSubType() != DataSubType.DATETIMETYPE) {
                    leftNode = (SQLQueryNode)sqlNode.getChild(1);
                    rightNode = (SQLQueryNode)sqlNode.getChild(0);
                }
                boolean bl2 = status = leftNode.getDataType().getSubType() == DataSubType.DATETIMETYPE && rightNode.getType() == 301047 && (rightNode.getDataType().getSubType() == DataSubType.INTERVALYMTYPE || rightNode.getDataType().getSubType() == DataSubType.INTERVALDTTYPE);
                if (status) {
                    boolean bl3 = status = leftNode.isSupported(dataSource) && ((SQLQueryNode)rightNode.getChild(0)).isSupported(dataSource) && ((SQLQueryNode)rightNode.getChild(0)).getDataType().isNumeric();
                }
                if (status) {
                    byte leftCCLType = leftNode.getDataType().getCCLTypeCode();
                    IntervalType intervalType = (IntervalType)rightNode.getDataType();
                    switch (intervalType.getQualifier()) {
                        case INTERVAL_YEAR: 
                        case INTERVAL_MONTH: 
                        case INTERVAL_DAY: {
                            status = leftCCLType != 58 && leftCCLType != 52;
                            break;
                        }
                        case INTERVAL_HOUR: 
                        case INTERVAL_MINUTE: 
                        case INTERVAL_SECOND: {
                            status = leftCCLType != 57;
                            break;
                        }
                        default: {
                            status = false;
                        }
                    }
                    if (status) {
                        IDataType[] fArguments = new IDataType[]{null, null};
                        fArguments[0] = leftNode.getDataType();
                        fArguments[1] = ((SQLQueryNode)rightNode.getChild(0)).getDataType();
                        status = SQLFunction.isFeatureSupported(capabilities, FUNCTION_NAMES.get((Object)intervalType.getQualifier()), fArguments);
                    }
                }
            }
        }
        if (status && !sqlNode.isSupported(dataSource)) {
            this.traceQueryCondition(status, "Expression needs to be converted.", trace);
        } else {
            this.traceQueryCondition(status, "Expression does not need to be converted.", trace);
        }
        return status;
    }

    static {
        FUNCTION_NAMES.put(IntervalQualifier.INTERVAL_YEAR, "AddYears");
        FUNCTION_NAMES.put(IntervalQualifier.INTERVAL_MONTH, "AddMonths");
        FUNCTION_NAMES.put(IntervalQualifier.INTERVAL_DAY, "AddDays");
        FUNCTION_NAMES.put(IntervalQualifier.INTERVAL_HOUR, "AddHours");
        FUNCTION_NAMES.put(IntervalQualifier.INTERVAL_MINUTE, "AddMinutes");
        FUNCTION_NAMES.put(IntervalQualifier.INTERVAL_SECOND, "AddSeconds");
    }
}

