/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueExpression;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntervalQualifier;
import com.cognos.xqe.data.types.IntervalType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.IntervalDayTimeValue;
import com.cognos.xqe.data.values.IntervalYearMonthValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import java.util.HashMap;
import java.util.Map;

public class ConvertDateTimeDifferenceExpression
extends RQETransformation {
    private static final Map<IntervalQualifier, String> FUNCTION_NAMES = new HashMap<IntervalQualifier, String>();

    public ConvertDateTimeDifferenceExpression() {
        this.mName = "Convert Date/Time - Data/Time to equivalent Expression";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301026};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLQueryNode lChild = (SQLQueryNode)node.getChild(0);
        SQLQueryNode rChild = (SQLQueryNode)node.getChild(1);
        SQLFunction functionNode = (SQLFunction)nodeFactory.createNode(301033);
        if (rChild.getType() != 301031) {
            SQLQueryNode temp = lChild;
            lChild = rChild;
            rChild = temp;
        }
        IntegerValue intValue = DataValueFactory.createIntegerValue();
        IntervalType dType = (IntervalType)rChild.getDataType();
        Value value = ((SQLLiteral)rChild).getValue();
        switch (dType.getQualifier()) {
            case INTERVAL_DAY: {
                intValue.set(((IntervalDayTimeValue)value).getDay());
                functionNode.setSubType(SQLFunction.SubType.DAYS_BETWEEN);
                break;
            }
            case INTERVAL_HOUR: {
                intValue.set(((IntervalDayTimeValue)value).getHour());
                functionNode.setSubType(SQLFunction.SubType.HOURS_BETWEEN);
                break;
            }
            case INTERVAL_MINUTE: {
                intValue.set(((IntervalDayTimeValue)value).getMinute());
                functionNode.setSubType(SQLFunction.SubType.MINUTES_BETWEEN);
                break;
            }
            case INTERVAL_SECOND: {
                intValue.set(((IntervalDayTimeValue)value).getSecond());
                functionNode.setSubType(SQLFunction.SubType.SECONDS_BETWEEN);
                break;
            }
            case INTERVAL_MONTH: {
                intValue.set(((IntervalYearMonthValue)value).getMonth());
                functionNode.setSubType(SQLFunction.SubType.MONTHS_BETWEEN);
                break;
            }
            case INTERVAL_YEAR: {
                intValue.set(((IntervalYearMonthValue)value).getYear());
                functionNode.setSubType(SQLFunction.SubType.YEARS_BETWEEN);
                break;
            }
        }
        functionNode.setFunctionName(FUNCTION_NAMES.get((Object)dType.getQualifier()));
        lChild.exchange(functionNode, true);
        ((SQLLiteral)rChild).setDataType(DataTypeFactory.getIntegerType());
        ((SQLLiteral)rChild).setValue(intValue);
        ((SQLQueryNode)node).invalidateSupportCache();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLComparison sqlNode = (SQLComparison)node;
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        boolean bl = status = dataSource != null && dataSource.isRelational();
        if (status && (status = sqlNode.isRelational())) {
            SQLQueryNode lChild = (SQLQueryNode)sqlNode.getChild(0);
            SQLQueryNode rChild = (SQLQueryNode)sqlNode.getChild(1);
            if (rChild.getType() != 301031) {
                lChild = (SQLQueryNode)sqlNode.getChild(1);
                rChild = (SQLQueryNode)sqlNode.getChild(0);
            }
            if (lChild.getType() == 301025 && ((SQLValueExpression)lChild).getSubType() == SQLValueExpression.SubType.SUBTRACT && rChild.getType() == 301031 && (((SQLLiteral)rChild).getDataType().getSubType() == DataSubType.INTERVALYMTYPE || ((SQLLiteral)rChild).getDataType().getSubType() == DataSubType.INTERVALDTTYPE)) {
                SQLQueryNode leftNode = (SQLQueryNode)lChild.getChild(0);
                SQLQueryNode rightNode = (SQLQueryNode)lChild.getChild(1);
                boolean bl2 = status = leftNode.getDataType().getSubType() == DataSubType.DATETIMETYPE && rightNode.getDataType().getSubType() == DataSubType.DATETIMETYPE && leftNode.isSupported(dataSource) && rightNode.isSupported(dataSource);
                if (status) {
                    byte leftCCLType = leftNode.getDataType().getCCLTypeCode();
                    byte rightCCLType = rightNode.getDataType().getCCLTypeCode();
                    IntervalType intervalType = (IntervalType)((SQLLiteral)rChild).getDataType();
                    switch (intervalType.getQualifier()) {
                        case INTERVAL_DAY: 
                        case INTERVAL_MONTH: 
                        case INTERVAL_YEAR: {
                            status = !DataTypeCode.isTime(leftCCLType) && !DataTypeCode.isTime(rightCCLType);
                            break;
                        }
                        case INTERVAL_HOUR: 
                        case INTERVAL_MINUTE: 
                        case INTERVAL_SECOND: {
                            status = !DataTypeCode.isDate(leftCCLType) && !DataTypeCode.isDate(rightCCLType);
                            break;
                        }
                        default: {
                            status = false;
                        }
                    }
                    if (status) {
                        IDataType[] fArguments = new IDataType[]{null, null};
                        fArguments[0] = leftNode.getDataType();
                        fArguments[1] = rightNode.getDataType();
                        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
                        status = SQLFunction.isFeatureSupported(capabilities, FUNCTION_NAMES.get((Object)intervalType.getQualifier()), fArguments);
                    }
                }
            } else {
                status = false;
            }
        }
        if (status && !sqlNode.isSupported(dataSource)) {
            this.traceQueryCondition(status, "Expression needs to be converted.", trace);
        } else {
            this.traceQueryCondition(status, "Expression does not need to be converted.", trace);
        }
        return status;
    }

    static {
        FUNCTION_NAMES.put(IntervalQualifier.INTERVAL_YEAR, "YearsBetween");
        FUNCTION_NAMES.put(IntervalQualifier.INTERVAL_MONTH, "MonthsBetween");
        FUNCTION_NAMES.put(IntervalQualifier.INTERVAL_DAY, "DaysBetween");
        FUNCTION_NAMES.put(IntervalQualifier.INTERVAL_HOUR, "HoursBetween");
        FUNCTION_NAMES.put(IntervalQualifier.INTERVAL_MINUTE, "MinutesBetween");
        FUNCTION_NAMES.put(IntervalQualifier.INTERVAL_SECOND, "SecondsBetween");
    }
}

