/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLCast;
import com.cognos.xqe.ast.sql.SQLDataType;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.types.TimestampType;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class ConvertDatetimeComparisonToCompatibleSQL
extends RQETransformation {
    public ConvertDatetimeComparisonToCompatibleSQL() {
        this.mName = "convert comparison between DATE and TIMESTAMP to Standard SQL";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{301026};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        SQLQueryNode child = (SQLQueryNode)node.getChild(0);
        if (child.getDataType().isTimestamp()) {
            child = (SQLQueryNode)node.getChild(1);
        }
        SQLCast castNode = (SQLCast)factory.createNode(301047);
        child.insertParent(castNode);
        SQLDataType dType = (SQLDataType)factory.createNode(301037);
        dType.setDataType(TimestampType.TIMESTAMPTYPE);
        castNode.addChild(dType);
        castNode.invalidateSupportCache();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryNode child0 = (SQLQueryNode)node.getChild(0);
        SQLQueryNode child1 = (SQLQueryNode)node.getChild(1);
        boolean bl = status = (child0.getDataType().isDate() && child1.getDataType().isTimestamp() || child0.getDataType().isTimestamp() && child1.getDataType().isDate()) && child1.getType() != 301055 && child1.getType() != 301059;
        if (status) {
            SQLQueryBlock qb = (SQLQueryBlock)node.getAncestorOfType(301004);
            IDataSource dataSource = qb.getDataSource();
            boolean bl2 = status = dataSource == null || !dataSource.getCapabilities().isSupported("supports.nonStandardDatetimeComparison");
        }
        if (status) {
            this.traceQueryCondition(status, "Expression needs to be converted.", trace);
        } else {
            this.traceQueryCondition(status, "Expression does not need to be converted.", trace);
        }
        return status;
    }
}

