/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLNativeSql;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;

public class ConvertDerivedColumnListToAliasList
extends RQETransformation {
    public ConvertDerivedColumnListToAliasList() {
        this(3);
    }

    public ConvertDerivedColumnListToAliasList(int passNumber) {
        this.mName = "Decompose derived column list.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{301004};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock qBlock = (SQLQueryBlock)node;
        List<String> derivedColumnsList = qBlock.getDerivedColumnList();
        this.setValueListAliasFromDerivedColumnList(environment, qBlock, derivedColumnsList);
        qBlock.setDerivedColumnList(null);
    }

    private void setValueListAliasFromDerivedColumnList(IPlanningEnvironment environment, IXQEQueryNode qBlock, List<String> derivedColumnsList) {
        IXQEQueryNode child = qBlock.getChild(0);
        if (child.getNodeType() == 301018) {
            this.setValueListAliasFromDerivedColumnList(environment, child.getChild(0), derivedColumnsList);
            this.setValueListAliasFromDerivedColumnList(environment, child.getChild(1), derivedColumnsList);
        } else {
            this.setValueListAliasFromDerivedColumnList2(environment, qBlock, derivedColumnsList);
        }
    }

    private void setValueListAliasFromDerivedColumnList2(IPlanningEnvironment environment, IXQEQueryNode node, List<String> derivedColumnsList) {
        SQLQueryBlock qBlock;
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode child = node.getChild(0);
        if (child.getType() == 301022) {
            node = child.getChild(child.getNumberChildren() - 1);
        }
        if (child.getType() == 301008) {
            node = child.getChild(0);
        }
        if ((qBlock = (SQLQueryBlock)node).getBlockType() == 301012) {
            SQLQueryBlock newqBlock = (SQLQueryBlock)factory.copyNode(qBlock);
            newqBlock.setPropertyValue("derivedColumnList", null);
            qBlock.insertParent(newqBlock);
            SQLProject newProject = (SQLProject)factory.createNode(301015);
            qBlock.insertParent(newProject);
            SQLValueList newvList = (SQLValueList)factory.createNode(301030);
            SQLNativeSql nativeNode = (SQLNativeSql)qBlock.getChild(0);
            SQLQueryItemList qItems = nativeNode.getDescQueryItemList();
            for (int i = 0; i < qItems.size(); ++i) {
                SQLQueryItem item = (SQLQueryItem)qItems.get(i);
                SQLFid fid = (SQLFid)factory.createNode(301032);
                fid.setName(item.getName());
                fid.setVirtualColumnNo(i);
                fid.setColumnNo(item.getColumnNo());
                fid.setSourceNo(item.getSourceNo());
                fid.setTableName(qBlock.getName());
                fid.setDataType(item.getDataType());
                newvList.addChild(fid);
            }
            newProject.addChild(newvList);
            qBlock = newqBlock;
        }
        ArrayList<SQLAlias> aliasList = new ArrayList<SQLAlias>();
        for (String derivedColumnName : derivedColumnsList) {
            SQLAlias alias = (SQLAlias)factory.createNode(301028);
            alias.setName(derivedColumnName);
            aliasList.add(alias);
        }
        SQLValueList vList = (SQLValueList)qBlock.getChild(0).getChild(1);
        vList.setAliasList(aliasList);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status = false;
        SQLQueryBlock qBlock = (SQLQueryBlock)node;
        IDataSource dataSource = qBlock.getDataSource();
        if (dataSource == null) {
            status = false;
        } else {
            boolean bl = status = qBlock.getDerivedColumnList() != null && dataSource.isRelational() && !dataSource.getCapabilities().isSupported("supports.derivedColumnLists");
            if (status) {
                IXQEQueryNode child = qBlock.getChild(0);
                status = child.getNumberChildren() > 1 && child.getChild(1).getType() == 301030 || child.getNodeType() == 301018 && child.getChild(0).getType() == 301004 && child.getChild(1).getType() == 301004 || child.getNodeType() == 301012 && !((SQLNativeSql)child).isPassThrough();
            }
        }
        XQETrace trace = environment.getTrace();
        if (status) {
            this.traceQueryCondition(status, "Derived column lists are not supported.", trace);
        } else {
            this.traceQueryCondition(status, "Derived column lists are either supported or not present.", trace);
        }
        return status;
    }
}

