/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLProduct;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.util.Governors;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ConvertJoinedTableToProduct
extends RQETransformation {
    public ConvertJoinedTableToProduct() {
        this(3);
    }

    public ConvertJoinedTableToProduct(int passNumber) {
        this.mName = "ConvertJoinedTableToProduct.";
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{301011};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLProduct product = (SQLProduct)nodeFactory.createNode(301014);
        SQLFilter filter = (SQLFilter)nodeFactory.createNode(301009);
        List<Integer> list = this.doTransformation((SQLJoin)node, product, filter, nodeFactory);
        if (node.getParent().getType() != 301009) {
            node.exchange(filter);
            filter.addChild(product, 0);
        } else {
            SQLQueryNode wherePredicate = (SQLQueryNode)node.getParent().getChild(1);
            List<SQLFid> fids = wherePredicate.getFieldIdentifiers();
            this.recalculateFIDs(list, fids);
            SQLLogical logical = (SQLLogical)nodeFactory.createNode(301027);
            logical.setSubType(SQLLogical.SubType.AND);
            wherePredicate.insertParent(logical);
            logical.addChild(filter.getChild(0).detach(), 0);
            node.exchange(product);
        }
        SQLQueryNode qblock = (SQLQueryNode)product.getAncestorOfType(301004);
        int[] anchorTypes = new int[]{301004, 301059, 301009};
        List<SQLFid> fids = qblock.getFieldIdentifiers(anchorTypes);
        this.recalculateFIDs(list, fids);
    }

    private void recalculateFIDs(List<Integer> columnCount, List<SQLFid> fids) {
        block0: for (SQLFid fid : fids) {
            int sourceNo = 0;
            int v = 0;
            for (Integer integer : columnCount) {
                if (fid.getVirtualColumnNo() < (v += integer.intValue())) {
                    fid.setSourceNo(sourceNo);
                    continue block0;
                }
                ++sourceNo;
            }
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLJoin jNode = (SQLJoin)node;
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IXQEQueryNode parent = node.getParent();
        SQLJoin.Hint hint = jNode.getHint();
        boolean bl = status = parent.getType() != 301011 && parent.getType() != 301014 && hint == SQLJoin.Hint.DEFAULT;
        if (status) {
            status = this.isLeftNestedInnerJoinExpr(jNode);
        }
        LinkedList<String> list = new LinkedList<String>();
        if (status) {
            if (qBlock.getDataSourceList().size() == 1) {
                status = !SQLJoin.isFeatureSupported(jNode, qBlock.getDataSource().getCapabilities()) || !jNode.isSupported(qBlock.getDataSource(), list);
            } else {
                boolean bl2 = status = node.getChild(0).getType() == 301011;
                if (!status) {
                    SQLJoin.SubType jType = jNode.getJoinType();
                    IRelationship.JoinFilterType jft = (IRelationship.JoinFilterType)((Object)jNode.getPropertyValue("joinFilterType"));
                    boolean filterJoinOptimization = false;
                    if (jft == IRelationship.JoinFilterType.FILTER_TYPE_IN || jft == IRelationship.JoinFilterType.FILTER_TYPE_BETWEEN || jft == IRelationship.JoinFilterType.FILTER_TYPE_TABLE) {
                        filterJoinOptimization = true;
                    }
                    ArrayList<filterWrapper> simpleFactors = new ArrayList<filterWrapper>();
                    IXQEQueryNode joinPredicate = jNode.getChild(2);
                    SQLFid leftFid = null;
                    SQLFid rightFid = null;
                    if (!filterJoinOptimization && joinPredicate.getChild(0).getType() == 301032 && joinPredicate.getChild(1).getType() == 301032) {
                        leftFid = (SQLFid)joinPredicate.getChild(0);
                        rightFid = (SQLFid)joinPredicate.getChild(1);
                    }
                    if (leftFid != null && rightFid != null) {
                        while (parent.getType() == 301009) {
                            SQLComparison comparison;
                            SQLComparison.SubType subType;
                            SQLFilter factor = (SQLFilter)parent;
                            SQLExpression predicate = factor.getPredicate();
                            if (predicate.getType() == 301026 && ((subType = (comparison = (SQLComparison)predicate).getSubType()) == SQLComparison.SubType.EQUAL || subType == SQLComparison.SubType.LESS || subType == SQLComparison.SubType.LESSEQUAL || subType == SQLComparison.SubType.GREATER || subType == SQLComparison.SubType.GREATEREQUAL)) {
                                if (predicate.getChild(0).getType() == 301031 && predicate.getChild(1).getType() == 301032) {
                                    simpleFactors.add(new filterWrapper(factor));
                                } else if (predicate.getChild(1).getType() == 301031 && predicate.getChild(0).getType() == 301032) {
                                    simpleFactors.add(new filterWrapper(factor));
                                }
                            }
                            parent = parent.getParent();
                        }
                    }
                    for (int i = 0; i < simpleFactors.size(); ++i) {
                        filterWrapper sFactor = (filterWrapper)simpleFactors.get(i);
                        if ((sFactor.getSourceNo() != leftFid.getSourceNo() || sFactor.getVirtualColumnNo() != leftFid.getVirtualColumnNo()) && (sFactor.getSourceNo() != rightFid.getSourceNo() || sFactor.getVirtualColumnNo() != rightFid.getVirtualColumnNo())) continue;
                        status = true;
                    }
                }
            }
            Governors governor = node.getGovernors();
            boolean bl3 = status = status || governor != null && governor.getSqlJoinSyntax() == Governors.SqlJoinSyntax.IMPLICIT;
        }
        if (status) {
            this.traceQueryCondition(status, "Explicit inner join needs to be converted to an implicit join." + SQLQueryNode.getUnsupportedReason(list), trace);
        } else {
            this.traceQueryCondition(status, "Explicit inner join does not need to be converted to an implicit join.", trace);
        }
        return status;
    }

    private boolean isLeftNestedInnerJoinExpr(SQLJoin node) {
        boolean status;
        boolean bl = status = node.getJoinType() == SQLJoin.SubType.INNER;
        if (status) {
            boolean bl2 = status = node.getChild(0).getType() != 301011 || this.isLeftNestedInnerJoinExpr((SQLJoin)node.getChild(0));
        }
        if (status) {
            status = node.getChild(1).getType() != 301011;
        }
        return status;
    }

    private List<Integer> doTransformation(SQLJoin node, SQLProduct product, SQLFilter filter, XQENodeFactory nodeFactory) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < 2; ++i) {
            SQLQueryNode child = (SQLQueryNode)node.getChild(0);
            if (child.getType() == 301011) {
                if (i != 0) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "i != 0");
                }
                list.addAll(this.doTransformation((SQLJoin)child, product, filter, nodeFactory));
                child.extract();
                continue;
            }
            child.detach();
            product.addChild(child);
            list.add(child.getQueryItemList().size());
        }
        SQLQueryNode joinPredicate = (SQLQueryNode)node.getChild(0).detach();
        List<SQLFid> fids = joinPredicate.getFieldIdentifiers();
        this.recalculateFIDs(list, fids);
        if (filter.getNumberChildren() > 0) {
            SQLLogical logical = (SQLLogical)nodeFactory.createNode(301027);
            logical.setSubType(SQLLogical.SubType.AND);
            logical.addChild(joinPredicate);
            logical.addChild(filter.getChild(0).detach());
            filter.addChild(logical);
        } else {
            filter.addChild(joinPredicate);
        }
        return list;
    }

    private final class filterWrapper {
        private SQLFilter factor;
        private SQLComparison predicate;
        private SQLFid fid;

        filterWrapper(SQLFilter theFactor) {
            this.factor = theFactor;
            this.predicate = (SQLComparison)this.factor.getPredicate();
            if (this.predicate.getChild(0).getType() == 301031) {
                this.fid = (SQLFid)this.predicate.getChild(1);
            } else if (this.predicate.getChild(1).getType() == 301031) {
                this.fid = (SQLFid)this.predicate.getChild(0);
            }
        }

        public int getSourceNo() {
            return this.fid.getSourceNo();
        }

        public int getVirtualColumnNo() {
            return this.fid.getVirtualColumnNo();
        }
    }
}

