/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.FloatValue;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class ConvertMedianAggregate
extends RQETransformation {
    private static final double ONE_HALF = 0.5;

    public ConvertMedianAggregate() {
        this.mName = "Convert MEDIAN aggregate.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301034};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLAggregate sqlNode = (SQLAggregate)node;
        sqlNode.setSubType(SQLAggregate.SubType.PERCENTILE_CONT);
        IXQEQueryNode sortKeyList = nodeFactory.createNode(301021);
        SQLSortKey sortKey = (SQLSortKey)nodeFactory.createNode(301020);
        sortKey.setAscending(true);
        node.getChild(0).insertParent(sortKey);
        sortKey.insertParent(sortKeyList);
        SQLLiteral literalNode = (SQLLiteral)nodeFactory.createNode(301031);
        FloatValue percentileValue = DataValueFactory.createFloatValue();
        percentileValue.set(0.5);
        literalNode.setValue(percentileValue);
        node.addChild(literalNode, 0);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLAggregate sqlNode = (SQLAggregate)node;
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        boolean bl = status = sqlNode.getSubType() == SQLAggregate.SubType.MEDIAN && (dataSource == null || !sqlNode.isSupported(dataSource));
        if (status) {
            this.traceQueryCondition(status, "MEDIAN aggregate needs to be converted.", trace);
        } else {
            this.traceQueryCondition(status, "MEDIAN aggregate doesn't need to be converted.", trace);
        }
        return status;
    }
}

