/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLDistinct;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLGroupBy;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.util.Governors;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.Collection;
import java.util.List;

public final class ConvertSQLGroupByToDistinct
extends RQETransformation {
    private static final String PERFORMANCE_CONVERT_GROUPBY_TO_DISTINCT = "performance.convertGroupByToDistinct";

    public ConvertSQLGroupByToDistinct() {
        this.mName = "Convert a SQLGroupBy node to a Distinct node.";
        this.mPassNumbers = new int[]{3};
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
        this.mTypes = new int[]{301010};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLGroupBy groupBy = (SQLGroupBy)node;
        SQLGroupByList groupByList = groupBy.getGroupByList();
        groupByList.detach();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getParent();
        Collection<IDataSource> dataSources = pQueryBlock.getDataSourceList();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLProject projectNode = (SQLProject)nodeFactory.createNode(301015);
        groupBy.exchange(projectNode, true);
        if (pQueryBlock.getParent().getType() != 301008) {
            SQLDistinct distinctNode = (SQLDistinct)nodeFactory.createNode(301008);
            SQLQueryBlock qBlock = (SQLQueryBlock)nodeFactory.createNode(301004);
            qBlock.setForeign(true);
            qBlock.setDataSourceList(dataSources);
            projectNode.insertParent(qBlock);
            qBlock.insertParent(distinctNode);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = this.projectionNeedDistinct(node);
        if (status) {
            this.traceQueryCondition(status, "GROUP BY can be converted to Distinct.", trace);
        } else {
            this.traceQueryCondition(status, "GROUP BY can not be converted to Distinct.", trace);
        }
        return status;
    }

    private boolean projectionNeedDistinct(IXQEQueryNode node) {
        Boolean status = false;
        int w = 0;
        int s = 0;
        IXQEQueryNode aVList = node.getChild(1);
        if (((SQLGroupBy)node).getGroupByList() == null) {
            return false;
        }
        List<IXQEQueryNode> fidListInGroupBy = ((SQLGroupBy)node).getGroupByList().getDescendantsOfTypeOrdered(301032, false);
        List<IXQEQueryNode> fidListInValueList = aVList.getDescendantsOfTypeOrdered(301032, false);
        for (IXQEQueryNode fidInGroupBy : fidListInGroupBy) {
            Boolean found = false;
            for (IXQEQueryNode fidInValueList : fidListInValueList) {
                if (!((SQLFid)fidInGroupBy).getName().equals(((SQLFid)fidInValueList).getName())) continue;
                found = true;
                break;
            }
            if (found.booleanValue()) continue;
            return false;
        }
        List<IXQEQueryNode> aggrs = aVList.getDescendantsOfTypeOrdered(301034, false);
        for (int i = 0; i < aggrs.size() && !status.booleanValue(); ++i) {
            IXQEQueryNode aggr = aggrs.get(i);
            if (((SQLAggregate)aggr).isWindowedAggregate()) {
                ++w;
                continue;
            }
            ++s;
        }
        if (w > 0 && s == 0) {
            return true;
        }
        if (w == 0 && s == 0) {
            Governors.GroupByOptimization optimization;
            Governors governors = node.getGovernors();
            if (governors != null && (optimization = governors.getGroupByOptimization()).equals((Object)Governors.GroupByOptimization.DISTINCT)) {
                return true;
            }
            SQLQueryBlock queryBlock = (SQLQueryBlock)node.getParent();
            IDataSource dataSource = queryBlock.getDataSource();
            if (dataSource != null && dataSource.isRelational() && node.isSupported(dataSource)) {
                IDataSourceCapabilities capabilities = dataSource.getCapabilities();
                status = capabilities.isSupported(PERFORMANCE_CONVERT_GROUPBY_TO_DISTINCT) && SQLDistinct.isFeatureSupported(capabilities);
            }
        }
        return status;
    }
}

