/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAbstractBooleanFunction;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class ConvertSQLIn
extends RQETransformation {
    public static final int MAX_IN_LIST_LENGTH = 10;

    public ConvertSQLIn() {
        this.mName = "Convert IN predicate to equivalent OR predicate.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301076};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        this.trimNotNotParent(node);
        IXQEQueryNode parent = node.getParent();
        SQLComparison.SubType cmpTp = SQLComparison.SubType.EQUAL;
        SQLLogical.SubType lgTp = SQLLogical.SubType.OR;
        IXQEQueryNode toReplace = node;
        if (parent != null && parent.getType() == 301027 && ((SQLLogical)parent).getSubType() == SQLLogical.SubType.NOT) {
            toReplace = parent;
            cmpTp = SQLComparison.SubType.NOTEQUAL;
            lgTp = SQLLogical.SubType.AND;
        }
        toReplace.exchange(this.createPredicate(factory, node, cmpTp, lgTp));
    }

    protected void trimNotNotParent(IXQEQueryNode node) {
        IXQEQueryNode parent = node.getParent();
        if (parent == null) {
            return;
        }
        IXQEQueryNode parentParent = parent.getParent();
        if (parentParent == null) {
            return;
        }
        while (parent.getType() == 301027 && ((SQLLogical)parent).getSubType() == SQLLogical.SubType.NOT && parentParent.getType() == 301027 && ((SQLLogical)parentParent).getSubType() == SQLLogical.SubType.NOT) {
            parent.extract();
            parentParent.extract();
            parent = node.getParent();
            if (parent == null) {
                return;
            }
            parentParent = parent.getParent();
            if (parentParent != null) continue;
            return;
        }
    }

    private IXQEQueryNode createPredicate(IXQENodeFactory factory, IXQEQueryNode node, SQLComparison.SubType cmpTp, SQLLogical.SubType lgTp) {
        SQLAbstractBooleanFunction predicate = null;
        IXQEQueryNode exprNode = node.getChild(0);
        IXQEQueryNode[] vList = node.getChild(1).getChildren();
        for (int i = 0; i < vList.length; ++i) {
            SQLComparison compareNode = (SQLComparison)factory.createNode(301026);
            compareNode.setSubType(cmpTp);
            compareNode.addChild(factory.deepCopyNode(exprNode));
            compareNode.addChild(vList[i].detach());
            if (predicate == null) {
                predicate = compareNode;
                continue;
            }
            SQLLogical logicalNode = (SQLLogical)factory.createNode(301027);
            logicalNode.setSubType(lgTp);
            logicalNode.addChild(predicate);
            logicalNode.addChild(compareNode);
            predicate = logicalNode;
        }
        return predicate;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = qBlock.getDataSource();
        IXQEQueryNode child = node.getChild(1);
        boolean bl = status = dataSource != null && node.getChild(0).getType() == 301032 && child.getType() == 301030 && child.getNumberChildren() < 10 && !node.isSupported(dataSource);
        if (status) {
            for (int i = 0; i < child.getNumberChildren() && status; ++i) {
                status = child.getChild(i).getType() == 301031;
            }
        }
        if (status) {
            this.traceQueryCondition(status, "IN predicate needs to be converted.", trace);
        } else {
            this.traceQueryCondition(status, "IN predicate does not need to be converted.", trace);
        }
        return status;
    }
}

