/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class ConvertSQLProjectToSQLGroupBy
extends RQETransformation {
    public ConvertSQLProjectToSQLGroupBy() {
        this.mName = "Convert a PROJECT node to a GROUP BY node.";
        this.mPassNumbers = new int[]{0};
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
        this.mTypes = new int[]{301015};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode groupBy = factory.createNode(301010);
        node.exchange(groupBy, true);
        SQLGroupByList groupByList = (SQLGroupByList)factory.createNode(301029);
        groupBy.addChild(groupByList);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        SQLValueList vList = ((SQLProject)node).getOutputList();
        List<IXQEQueryNode> aggregates = vList.getDescendantsOfTypeOrdered(301034, 301059);
        for (IXQEQueryNode queryNode : aggregates) {
            if (queryNode.getFirstChildByType(301041) != null) continue;
            status = true;
            break;
        }
        if (status) {
            this.traceQueryCondition(status, "SQLProject node contains a standard aggregate.", trace);
        } else {
            this.traceQueryCondition(status, "SQLProject node doesn't contain a standard aggregate.", trace);
        }
        return status;
    }
}

