/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.ISQLTypeComparable;
import com.cognos.xqe.ast.sql.SQLCast;
import com.cognos.xqe.ast.sql.SQLDataType;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class ConvertToComparableTypes
extends RQETransformation {
    private static final String CAST_PROP = "expressions.Cast";

    public ConvertToComparableTypes() {
        this.mName = "Normalize Comparable Types.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301074, 301073};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock queryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = queryBlock.getDataSource();
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        ISQLTypeComparable typeComp = (ISQLTypeComparable)((Object)node);
        IXQEQueryNode[] expressions = typeComp.getExpressions();
        IDataType[] incompatibleTypes = SQLQueryNode.getIncompatibleDataTypes(expressions, dataSource);
        XQENodeFactory factory = environment.getNodeFactory();
        while (incompatibleTypes != null) {
            IDataType fromType = incompatibleTypes[0];
            IDataType toDataType = incompatibleTypes[1];
            String key = capabilities.generateKey(CAST_PROP, incompatibleTypes);
            if (key == null) {
                fromType = incompatibleTypes[1];
                toDataType = incompatibleTypes[0];
            }
            for (int i = 0; expressions.length > i; ++i) {
                if (((ISQLQueryNode)expressions[i]).getDataType().getCCLTypeCode() != fromType.getCCLTypeCode()) continue;
                SQLCast castTo = (SQLCast)factory.createNode(301047);
                SQLDataType dType = (SQLDataType)factory.createNode(301037);
                IDataType childType = ((ISQLQueryNode)expressions[i]).getDataType();
                dType.setDataType(DataTypeFactory.getDataType(toDataType.getCCLTypeCode(), childType.getPrecision(), childType.getScale()));
                expressions[i].exchange(castTo);
                castTo.addChild(expressions[i]);
                castTo.addChild(dType);
                expressions[i] = castTo;
            }
            incompatibleTypes = SQLQueryNode.getIncompatibleDataTypes(expressions, dataSource);
        }
        typeComp.setIncompatibleType(false);
        queryBlock.setForeign(true);
        ((SQLQueryNode)node).invalidateSupportCache();
        queryBlock.setForeign(queryBlock.getChild(0).isSupported(dataSource));
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource ds = pQueryBlock.getDataSource();
        boolean result = ds != null;
        ISQLTypeComparable typeComp = null;
        IDataType[] incompatibleTypes = null;
        if (result) {
            typeComp = (ISQLTypeComparable)((Object)node);
            incompatibleTypes = SQLQueryNode.getIncompatibleDataTypes(typeComp.getExpressions(), ds);
            boolean bl = result = incompatibleTypes != null && this.childrenSupported(node, ds);
        }
        if (result) {
            IDataSourceCapabilities capabilities = ds.getCapabilities();
            String key = capabilities.generateKey("dataType.promotion", incompatibleTypes);
            if (key == null) {
                IDataType tempType = incompatibleTypes[0];
                incompatibleTypes[0] = incompatibleTypes[1];
                incompatibleTypes[1] = tempType;
                key = capabilities.generateKey("dataType.promotion", incompatibleTypes);
            }
            result = key != null && capabilities.getBooleanValue(key, false);
        }
        return result && !node.isSupported(ds);
    }

    private boolean childrenSupported(IXQEQueryNode node, IDataSource dataSource) {
        IXQEQueryNode[] children = node.getChildren();
        boolean supported = true;
        for (int i = 0; i < children.length && supported; ++i) {
            supported = children[i].isSupported(dataSource);
        }
        return supported;
    }
}

