/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLDistinct;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import java.util.ArrayList;
import java.util.List;

public class DecomposeSQLDistinctWithNestedWindowedAggregates
extends RQETransformation {
    static final String DERIVED_TABLE_NAME = "D1";
    public static final String CONTAINS_WINDOW_AGGREGATION = "containsWindowAggregation";
    public static final String SUPPORTS_DISTINCT_WINDWOSAGGEGATION = "supports.distinct.WindowAggregation";

    public DecomposeSQLDistinctWithNestedWindowedAggregates() {
        this.mName = "Decompose SQLDistinct with anayltic functions.";
        this.mPassNumbers = new int[]{13};
        this.mTypes = new int[]{301008};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        SQLQueryBlock childQueryBlock = (SQLQueryBlock)node.getChild(0);
        node.detachChild(childQueryBlock);
        childQueryBlock.setName(DERIVED_TABLE_NAME);
        SQLProject derived = (SQLProject)nodeFactory.createNode(301015);
        derived.setPropertyValue("collapsible", false);
        node.addChild(derived);
        derived.addChild(childQueryBlock, 0);
        SQLValueList projection = (SQLValueList)childQueryBlock.getChild(0).getChild(1);
        List<SQLAlias> originalAlialist = projection.getAliasList();
        if (originalAlialist == null) {
            originalAlialist = new ArrayList<SQLAlias>(projection.getNumberChildren());
            for (int i = 0; i < projection.getNumberChildren(); ++i) {
                SQLAlias aliasNode = (SQLAlias)nodeFactory.createNode(301028);
                if (projection.getChild(i).getType() == 301032) {
                    aliasNode.setName(((SQLFid)projection.getChild(i)).getName());
                } else {
                    aliasNode.setName("C" + i);
                }
                originalAlialist.add(aliasNode);
            }
            projection.setAliasList(originalAlialist);
        }
        SQLValueList derivedProjection = this.buildProjection(environment, projection, originalAlialist, 0, 0);
        derived.addChild(derivedProjection);
        ArrayList<SQLAlias> aliasList = new ArrayList<SQLAlias>();
        for (int i = 0; i < derivedProjection.getNumberChildren(); ++i) {
            SQLAlias aliasNode = (SQLAlias)nodeFactory.createNode(301028);
            aliasNode.setName(originalAlialist.get(i).getName());
            aliasList.add(aliasNode);
        }
        derivedProjection.setAliasList(aliasList);
        SQLQueryItemList queryItemspBlock = new SQLQueryItemList();
        for (int i = 0; i < derivedProjection.getNumberChildren(); ++i) {
            SQLFid fid = (SQLFid)derivedProjection.getChild(i);
            SQLQueryItem qItem = new SQLQueryItem(((SQLAlias)aliasList.get(i)).getName(), fid.getDataType(), fid.getColumnNo());
            qItem.setTableName(DERIVED_TABLE_NAME);
            qItem.setSourceNo(fid.getSourceNo());
            queryItemspBlock.add(qItem);
        }
        pQueryBlock.setQueryItemList(queryItemspBlock);
        node.setPropertyValue(CONTAINS_WINDOW_AGGREGATION, true);
    }

    private SQLValueList buildProjection(IPlanningEnvironment env, SQLValueList projection, List<SQLAlias> alialist, int sNo, int bColNo) {
        XQENodeFactory nodeFactory = env.getNodeFactory();
        SQLValueList vList = (SQLValueList)nodeFactory.createNode(301030);
        for (int i = 0; i < projection.getNumberChildren(); ++i) {
            SQLExpression exprNode = (SQLExpression)projection.getChild(i);
            SQLFid fid = (SQLFid)nodeFactory.createNode(301032);
            fid.setSourceNo(sNo);
            fid.setColumnNo(i);
            fid.setVirtualColumnNo(bColNo + i);
            fid.setDataType(exprNode.getDataType());
            fid.setIsNullable(exprNode.isNullable());
            fid.setName(alialist.get(i).getName());
            fid.setTableName(DERIVED_TABLE_NAME);
            vList.addChild(fid, i);
        }
        return vList;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        SQLDistinct sqlDistinct = (SQLDistinct)node;
        SQLValueList valueList = sqlDistinct.getOutputList();
        boolean status = false;
        if (null != dataSource) {
            boolean supportDistinctWindow = dataSource.getCapabilities().isSupported(SUPPORTS_DISTINCT_WINDWOSAGGEGATION);
            if (null != valueList && valueList.hasDescendantOfType(301041, true) && !supportDistinctWindow && null == node.getPropertyValue(CONTAINS_WINDOW_AGGREGATION)) {
                status = true;
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Need to decompose DISTINCT node", trace);
        } else {
            this.traceQueryCondition(status, "No need to decompose DISTINCT node", trace);
        }
        return status;
    }
}

