/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLGroupBy;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.ast.sql.SQLHaving;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.preoptimization.SQLPreoptimizerUtil;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public final class DecomposeSQLGroupBy
extends RQETransformation {
    public DecomposeSQLGroupBy() {
        this.mName = "Decompose a SQLGroupBy node.";
        this.mPassNumbers = new int[]{13};
        this.mTypes = new int[]{301010};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        List<IXQEQueryNode> exprList = null;
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getParent();
        Collection<IDataSource> dataSources = pQueryBlock.getDataSourceList();
        IDataSource dataSource = pQueryBlock.getDataSource();
        pQueryBlock.setForeign(false);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLQueryNode child = (SQLQueryNode)node.getChild(0);
        SQLValueList projectList = (SQLValueList)node.getChild(1);
        SQLGroupByList groupByList = ((SQLGroupBy)node).getGroupByList();
        SQLQueryBlock qBlock = (SQLQueryBlock)nodeFactory.createNode(301004);
        qBlock.setForeign(true);
        qBlock.setDataSourceList(dataSources);
        child.insertParent(qBlock);
        List<IXQEQueryNode> aggrList = this.getExcludedAggregates(node, dataSource);
        if (aggrList == null) {
            exprList = projectList.getProjectableExpressions(dataSource);
        } else {
            exprList = projectList.getProjectableExpressionsExcludingAnchorList(dataSource, aggrList);
            if (groupByList != null) {
                exprList.addAll(groupByList.getProjectableExpressions(dataSource));
            }
        }
        SQLQueryItemList SQLQueryItemList2 = null;
        SQLRelation sqlRelation = null;
        if (child instanceof SQLRelation) {
            sqlRelation = (SQLRelation)child;
        }
        if (sqlRelation != null) {
            SQLQueryItemList2 = sqlRelation.getQueryItemList();
        }
        SQLValueList vList = SQLPreoptimizerUtil.buildProjection(environment, exprList, 0, 0, dataSource, SQLQueryItemList2);
        if (((SQLGroupBy)node).isReductionGroupBy()) {
            vList.setAliasList(projectList.getAliasList());
        }
        qBlock.setQueryItemList(SQLPreoptimizerUtil.getQueryItemList(child.getQueryItemList(), vList));
        SQLProject pNode = (SQLProject)nodeFactory.createNode(301015);
        qBlock.getChild(0).insertParent(pNode);
        pNode.addChild(vList);
        if (aggrList == null) {
            IXQEQueryNode sqlGroupBy = nodeFactory.createNode(301010);
            pNode.exchange(sqlGroupBy, true);
            if (groupByList != null) {
                groupByList.move(sqlGroupBy);
            }
            IXQEQueryNode sqlProject = nodeFactory.createNode(301015);
            node.exchange(sqlProject, true);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLGroupBy groupBy = (SQLGroupBy)node;
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = qBlock.getDataSource();
        IXQEQueryNode child = node.getChild(0);
        SQLGroupByList groupByList = ((SQLGroupBy)node).getGroupByList();
        if (groupByList != null) {
            groupByList.validate(true);
        }
        LinkedList<String> list = new LinkedList<String>();
        if (dataSource == null || !dataSource.isRelational() || node.getDescendantsOfType(1002, false).length != 0) {
            status = false;
        } else if (child.getType() == 301004 && ((SQLQueryBlock)child).getName() == null) {
            status = false;
        } else if (!child.isSupported(dataSource)) {
            status = false;
        } else {
            boolean bl = status = groupBy.getHavingClause() == null && !groupBy.isSupported(dataSource, list) && !this.hasWindowedAggregatesInScope(groupBy);
            if (status) {
                this.checkStandardAggregateNesting(node, environment);
                this.checkForGroupingSetOperations(node);
            }
        }
        if (status) {
            this.traceQueryCondition(status, "GROUP BY operator is not supported." + SQLQueryNode.getUnsupportedReason(list), trace);
        } else {
            this.traceQueryCondition(status, "GROUP BY operator is supported.", trace);
        }
        return status;
    }

    public void checkStandardAggregateNesting(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLValueList projectList = ((SQLGroupBy)node).getOutputList();
        List<IXQEQueryNode> aggrs1 = projectList.getDescendantsOfTypeOrdered(301034, false, 301059);
        for (IXQEQueryNode aggr : aggrs1) {
            if (!((SQLAggregate)aggr).hasAggregates()) continue;
            throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedStandardAggregateNesting);
        }
        SQLHaving havingClause = ((SQLGroupBy)node).getHavingClause();
        if (havingClause != null) {
            List<IXQEQueryNode> aggrs2 = havingClause.getDescendantsOfTypeOrdered(301034, false, 301059);
            for (IXQEQueryNode aggr : aggrs2) {
                if (!((SQLAggregate)aggr).hasAggregates()) continue;
                throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedStandardAggregateNesting);
            }
        }
    }

    private boolean hasWindowedAggregatesInScope(SQLGroupBy groupBy) {
        SQLValueList valueList = groupBy.getValueList();
        SQLGroupByList groupByList = groupBy.getGroupByList();
        return null != valueList && valueList.hasWindowedAggregates() || null != groupByList && groupByList.hasWindowedAggregates();
    }

    private void checkForGroupingSetOperations(IXQEQueryNode node) {
        SQLGroupByList groupByList = ((SQLGroupBy)node).getGroupByList();
        if (groupByList != null) {
            IXQEQueryNode child = null;
            for (int i = 0; i < groupByList.getNumberChildren(); ++i) {
                child = groupByList.getChild(i);
                if (child.getType() != 301056 && child.getType() != 301057 && child.getType() != 301058) continue;
                throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedGroupingOperator);
            }
        }
    }

    private List<IXQEQueryNode> getExcludedAggregates(IXQEQueryNode node, IDataSource dataSource) {
        Boolean status = true;
        SQLValueList projectList = (SQLValueList)node.getChild(1);
        List<IXQEQueryNode> aggrList = projectList.getDescendantsOfTypeOrdered(301034, false, 301059);
        for (int i = 0; i < aggrList.size() && status.booleanValue(); ++i) {
            IXQEQueryNode aggr = aggrList.get(i);
            status = aggr.isSupported(dataSource);
        }
        SQLGroupByList groupByList = ((SQLGroupBy)node).getGroupByList();
        if (status.booleanValue() && groupByList != null) {
            status = groupByList.isSupported(dataSource);
        }
        if (status.booleanValue()) {
            return null;
        }
        return aggrList;
    }
}

