/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLGroupBy;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.preoptimization.SQLPreoptimizerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class DecomposeSQLGroupByWithWindowedAggrNestedInStandardAggr
extends RQETransformation {
    static final String DERIVED_TABLE_NAME = "D1";

    public DecomposeSQLGroupByWithWindowedAggrNestedInStandardAggr() {
        this.mName = "Decompose windowed aggregate nested in standard aggregate.";
        this.mPassNumbers = new int[]{13};
        this.mTypes = new int[]{301010};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        IDataSource dataSource;
        SQLGroupByList groupByList;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLQueryBlock parentQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        parentQueryBlock.setForeign(false);
        SQLValueList projectionList = (SQLValueList)node.getChild(1);
        List<SQLAggregate> nestedAggregates = SQLPreoptimizerUtil.findAggregatesWithNesting(projectionList);
        SQLQueryNode dfNode = (SQLQueryNode)node.getChild(0);
        SQLQueryBlock subQBlock = (SQLQueryBlock)nodeFactory.createNode(301004);
        subQBlock.setDataSourceList(parentQueryBlock.getDataSourceList());
        subQBlock.setName(DERIVED_TABLE_NAME);
        subQBlock.setForeign(false);
        dfNode.insertParent(subQBlock);
        ArrayList<IXQEQueryNode> excludeList = new ArrayList<IXQEQueryNode>();
        excludeList.addAll(nestedAggregates);
        List<IXQEQueryNode> projectableItems = projectionList.getProjectableExpressionsExcludingAnchorList(excludeList, environment);
        SQLValueList newProjection = SQLPreoptimizerUtil.buildProjection(environment, projectableItems, 0, 0, subQBlock.getDataSource());
        boolean bIsGroupByNeededForSubquery = false;
        for (IXQEQueryNode item : projectableItems) {
            if (item.getNodeType() != 301034 || ((SQLAggregate)item).isWindowedAggregate()) continue;
            bIsGroupByNeededForSubquery = true;
            break;
        }
        IXQEQueryNode groupByListForSubquery = null;
        if (bIsGroupByNeededForSubquery && (groupByList = ((SQLGroupBy)node).getGroupByList()) != null) {
            groupByListForSubquery = nodeFactory.deepCopyNode(groupByList);
        }
        ArrayList<SQLAlias> aliasList = new ArrayList<SQLAlias>();
        for (int i = 0; i < newProjection.getNumberChildren(); ++i) {
            SQLAlias aliasNode = (SQLAlias)nodeFactory.createNode(301028);
            aliasNode.setName("C" + i);
            aliasList.add(aliasNode);
        }
        newProjection.setAliasList(aliasList);
        List<SQLAlias> outerAliasList = projectionList.getAliasList();
        if (outerAliasList == null) {
            outerAliasList = new ArrayList<SQLAlias>();
            for (int i = 0; i < projectionList.getNumberChildren(); ++i) {
                outerAliasList.add(null);
            }
        }
        for (int i = 0; i < projectionList.getNumberChildren(); ++i) {
            if (outerAliasList.get(i) != null || projectionList.getChild(i).getType() != 301032) continue;
            SQLAlias aliasNode = (SQLAlias)nodeFactory.createNode(301028);
            aliasNode.setName(((SQLFid)projectionList.getChild(i)).getName());
            outerAliasList.set(i, aliasNode);
        }
        SQLQueryItemList queryItems = new SQLQueryItemList();
        HashSet<String> fidNameList = new HashSet<String>();
        List<IXQEQueryNode> fids = node.getDescendantsOfTypeOrdered(301032, 301004);
        for (int i = 0; i < fids.size(); ++i) {
            SQLFid fid = (SQLFid)fids.get(i);
            fid.setName(((SQLAlias)aliasList.get(fid.getColumnNo())).getName());
            fid.setTableName(DERIVED_TABLE_NAME);
            if (!fidNameList.add(fid.getName())) continue;
            SQLQueryItem qItem = new SQLQueryItem(fid.getName(), fid.getDataType(), fid.getColumnNo());
            qItem.setTableName(DERIVED_TABLE_NAME);
            qItem.setSourceNo(0);
            queryItems.add(qItem);
        }
        subQBlock.setDerivedColumnList(null);
        subQBlock.setQueryItemList(queryItems);
        SQLProject project = null;
        project = groupByListForSubquery != null ? (SQLProject)nodeFactory.createNode(301010) : (SQLProject)nodeFactory.createNode(301015);
        dfNode.insertParent(project);
        project.setCollapsible(false);
        project.addChild(newProjection);
        if (groupByListForSubquery != null) {
            project.addChild(groupByListForSubquery);
        }
        if ((dataSource = subQBlock.getDataSource()) != null && project.isSupported(dataSource)) {
            subQBlock.setForeign(true);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        SQLValueList vList = (SQLValueList)node.getChild(1);
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = qBlock.getDataSource();
        status = node.getChild(0).getType() != 301053 && !SQLPreoptimizerUtil.findAggregatesWithNesting(vList).isEmpty();
        LinkedList<String> list = new LinkedList<String>();
        if (status && dataSource != null && dataSource.isRelational()) {
            boolean bl = status = !qBlock.isSupported(dataSource, list);
        }
        if (status) {
            super.traceQueryCondition(status, "GroupBy has to be decomposed." + SQLQueryNode.getUnsupportedReason(list), trace);
        } else {
            super.traceQueryCondition(status, "GroupBy does not contain windowed aggregate nested in standard aggregate.", trace);
        }
        return status;
    }
}

