/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.preoptimization.SQLPreoptimizerUtil;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public final class DecomposeSQLProject
extends RQETransformation {
    protected static final String DECOMPOSE_SQL_PROJECT_APPLIED = "DecomposeSQLProjectApplied";

    public DecomposeSQLProject() {
        this.mName = "Decompose a SQLProject node.";
        this.mPassNumbers = new int[]{13};
        this.mTypes = new int[]{301015};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        Collection<IDataSource> dataSources = pQueryBlock.getDataSourceList();
        IDataSource dataSource = pQueryBlock.getDataSource();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLValueList vList1 = (SQLValueList)node.getChild(1);
        List<IXQEQueryNode> exprList = vList1.getProjectableExpressions(dataSource);
        SQLQueryItemList SQLQueryItemList2 = SQLBinderUtil.getQueryItemList((SQLQueryNode)node);
        SQLValueList vList2 = SQLPreoptimizerUtil.buildProjection(environment, exprList, 0, 0, dataSource, SQLQueryItemList2);
        SQLQueryBlock qBlock = (SQLQueryBlock)nodeFactory.createNode(301004);
        qBlock.setForeign(true);
        qBlock.setDataSourceList(dataSources);
        SQLQueryNode child = (SQLQueryNode)node.getChild(0);
        child.insertParent(qBlock);
        if (vList2.getNumberChildren() > 0) {
            qBlock.setQueryItemList(SQLPreoptimizerUtil.getQueryItemList(child.getQueryItemList(), vList2));
            SQLProject pNode = (SQLProject)nodeFactory.createNode(301015);
            qBlock.getChild(0).insertParent(pNode);
            pNode.addChild(vList2);
        }
        node.setPropertyValue(DECOMPOSE_SQL_PROJECT_APPLIED, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        IXQEQueryNode[] windows;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        SQLQueryNode child = (SQLQueryNode)node.getChild(0);
        LinkedList<String> list = new LinkedList<String>();
        boolean status = node.getPropertyValue(DECOMPOSE_SQL_PROJECT_APPLIED) == Boolean.TRUE ? false : (dataSource == null ? false : (child.getType() == 301004 && ((SQLQueryBlock)child).getName() == null ? false : (!dataSource.isRelational() ? false : (!child.isSupported(dataSource, list) ? false : !((SQLQueryNode)node).isSupported(dataSource, list)))));
        SQLValueList vList = null;
        if (status && (windows = (vList = (SQLValueList)node.getChild(1)).getDescendantsOfType(301041, false)).length > 0) {
            IXQEQueryNode[] aggregates = vList.getDescendantsOfType(301034, false);
            for (int i = 0; i < aggregates.length; ++i) {
                if (aggregates[i].getDescendantsOfType(301041, false).length > 0) continue;
                aggregates[i].throwInternalError("Illegal combination of standard and extended aggregates.");
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Projection is not supported." + SQLQueryNode.getUnsupportedReason(list), trace);
        } else {
            this.traceQueryCondition(status, "Projection is supported.", trace);
        }
        return status;
    }
}

