/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.preoptimization.SQLPreoptimizerUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class DecomposeSQLProjectWithNestedAggregates
extends RQETransformation {
    static final String DERIVED_TABLE_NAME = "D1";

    public DecomposeSQLProjectWithNestedAggregates() {
        this.mName = "Decompose Nested Aggregate.";
        this.mPassNumbers = new int[]{3, 14};
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
        this.mTypes = new int[]{301015};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLQueryBlock parentQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        SQLValueList projectionList = (SQLValueList)node.getChild(1);
        List<SQLAggregate> nestedAggregates = SQLPreoptimizerUtil.findAggregatesWithNesting(projectionList);
        SQLQueryNode dfNode = (SQLQueryNode)node.getChild(0);
        SQLQueryBlock newQBlock = (SQLQueryBlock)nodeFactory.createNode(301004);
        newQBlock.setDataSourceList(parentQueryBlock.getDataSourceList());
        newQBlock.setName(DERIVED_TABLE_NAME);
        newQBlock.setForeign(true);
        dfNode.insertParent(newQBlock);
        ArrayList<IXQEQueryNode> excludeList = new ArrayList<IXQEQueryNode>();
        excludeList.addAll(nestedAggregates);
        List<IXQEQueryNode> projectableItems = projectionList.getProjectableExpressionsExcludingAnchorList(excludeList, environment);
        SQLValueList newProjection = SQLPreoptimizerUtil.buildProjection(environment, projectableItems, 0, 0, newQBlock.getDataSource());
        ArrayList<SQLAlias> aliasList = new ArrayList<SQLAlias>();
        for (int i = 0; i < newProjection.getNumberChildren(); ++i) {
            SQLAlias aliasNode = (SQLAlias)nodeFactory.createNode(301028);
            aliasNode.setName("C" + i);
            aliasList.add(aliasNode);
        }
        newProjection.setAliasList(aliasList);
        List<SQLAlias> aliasList2 = projectionList.getAliasList();
        if (aliasList2 == null) {
            aliasList2 = new ArrayList<SQLAlias>();
            for (int i = 0; i < projectionList.getNumberChildren(); ++i) {
                aliasList2.add(null);
            }
        }
        for (int i = 0; i < projectionList.getNumberChildren(); ++i) {
            if (aliasList2.get(i) != null || projectionList.getChild(i).getType() != 301032) continue;
            SQLAlias aliasNode = (SQLAlias)nodeFactory.createNode(301028);
            aliasNode.setName(((SQLFid)projectionList.getChild(i)).getName());
            aliasList2.set(i, aliasNode);
        }
        SQLQueryItemList queryItems = new SQLQueryItemList();
        HashSet<String> fidNameList = new HashSet<String>();
        List<IXQEQueryNode> fids = node.getDescendantsOfTypeOrdered(301032, 301004);
        for (int i = 0; i < fids.size(); ++i) {
            SQLFid fid = (SQLFid)fids.get(i);
            fid.setName(((SQLAlias)aliasList.get(fid.getColumnNo())).getName());
            fid.setTableName(DERIVED_TABLE_NAME);
            if (!fidNameList.add(fid.getName())) continue;
            SQLQueryItem qItem = new SQLQueryItem(fid.getName(), fid.getDataType(), fid.getColumnNo());
            qItem.setTableName(DERIVED_TABLE_NAME);
            qItem.setSourceNo(0);
            queryItems.add(qItem);
        }
        newQBlock.setDerivedColumnList(null);
        newQBlock.setQueryItemList(queryItems);
        SQLProject project = (SQLProject)nodeFactory.createNode(301015);
        dfNode.insertParent(project);
        project.setCollapsible(false);
        project.addChild(newProjection);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        SQLValueList vList = (SQLValueList)node.getChild(1);
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = qBlock.getDataSource();
        status = node.getChild(0).getType() != 301053 && !SQLPreoptimizerUtil.findAggregatesWithNesting(vList).isEmpty();
        LinkedList<String> list = new LinkedList<String>();
        if (status && dataSource != null && dataSource.isRelational()) {
            boolean bl = status = !qBlock.isSupported(dataSource, list);
        }
        if (status) {
            super.traceQueryCondition(status, "Projection has to be decomposed." + SQLQueryNode.getUnsupportedReason(list), trace);
        } else {
            super.traceQueryCondition(status, "Projection does not contain a nested aggregate.", trace);
        }
        return status;
    }
}

