/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLWith;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DecomposeSQLWith
extends RQETransformation {
    public static final String DECOMPOSE_SQLWITH = "decomposeSQLWith";

    public DecomposeSQLWith() {
        this.mName = "Decompose a SQLWith node.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{301022};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        DecomposeSQLWith.convertWithToDerivedTable(node, environment);
        for (int i = node.getNumberChildren() - 2; i >= 0; --i) {
            SQLQueryBlock qb = (SQLQueryBlock)node.getChild(i);
            if (qb.getReferenceCount() > 0) continue;
            qb.detach();
        }
        DecomposeSQLWith.updateWithClause((SQLWith)node);
    }

    public static void updateWithClause(SQLWith withNode) {
        SQLQueryBlock qBlock = (SQLQueryBlock)withNode.getParent();
        if (withNode.getNumberChildren() == 1) {
            IXQEQueryNode child = withNode.getChild(0);
            if (child.getType() == 301004) {
                child.extract();
            }
            withNode.extract();
        } else {
            withNode.resetNameList();
            qBlock.setPropertyValue(DECOMPOSE_SQLWITH, Boolean.TRUE);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        int nChildren = node.getNumberChildren();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getParent();
        IDataSource dataSource = qBlock.getDataSource();
        boolean status = qBlock.isForeign() && qBlock.getPropertyValue(DECOMPOSE_SQLWITH) == null;
        LinkedList<String> list = new LinkedList<String>();
        if (status && dataSource != null) {
            status = false;
            for (int i = 0; i < nChildren - 1 && !status; ++i) {
                status = !((SQLQueryNode)node.getChild(i)).isSupported(dataSource, list);
            }
        }
        if (status && list.size() == 0) {
            list.add("With clause is not bound to a single data source");
        }
        if (status) {
            this.traceQueryCondition(status, "A WITH clause has to be decomposed." + SQLQueryNode.getUnsupportedReason(list), trace);
        } else {
            this.traceQueryCondition(status, "A With clause doesn't have to be decomposed.", trace);
        }
        return status;
    }

    private static void convertWithToDerivedTable(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean replaced;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        List<IXQEQueryNode> list = node.getDescendantsOfTypeOrdered(301016, false);
        DecomposeSQLWith.updateRefCountInCommonTable(node, list);
        LinkedList<IXQEQueryNode> addendum = new LinkedList<IXQEQueryNode>();
        do {
            replaced = false;
            if (addendum.size() > 0) {
                list.addAll(addendum);
                addendum.clear();
            }
            Iterator<IXQEQueryNode> iterator = list.iterator();
            while (iterator.hasNext()) {
                boolean mustCopy;
                SQLRelation rNode = (SQLRelation)iterator.next();
                if (!rNode.isWithClauseQueryRef()) {
                    iterator.remove();
                    continue;
                }
                SQLQueryBlock qBlock = ((SQLWith)node).getQueryByName(rNode.getName());
                if (qBlock == null) {
                    iterator.remove();
                    continue;
                }
                IDataSource ds = qBlock.getDataSource();
                if (qBlock.getReferenceCount() != 1 && (ds == null || !qBlock.isSupported(ds)) && !(mustCopy = DecomposeSQLWith.isReferencedFromReusableQuery(node, rNode))) continue;
                if (qBlock.getReferenceCount() == 1) {
                    qBlock.move(rNode);
                    rNode.extract();
                    if (qBlock.getParent().getType() == 301004) {
                        if (qBlock.getDerivedColumnList() != null) {
                            ((SQLQueryBlock)qBlock.getParent()).setDerivedColumnList(qBlock.getDerivedColumnList());
                        }
                        qBlock.extract();
                    }
                } else {
                    SQLQueryBlock copied = (SQLQueryBlock)nodeFactory.deepCopyNode(qBlock);
                    rNode.exchange(copied);
                    List<IXQEQueryNode> copiedSQLRelations = copied.getDescendantsOfTypeOrdered(301016, false);
                    DecomposeSQLWith.increaseSQLQueryBlockRefCountForNewSQLRelations((SQLWith)node, copiedSQLRelations);
                    addendum.addAll(copiedSQLRelations);
                    if (copied.getParent().getType() == 301004) {
                        if (copied.getDerivedColumnList() != null) {
                            ((SQLQueryBlock)copied.getParent()).setDerivedColumnList(copied.getDerivedColumnList());
                        }
                        copied.extract();
                    }
                    qBlock.decrementReferenceCount();
                }
                iterator.remove();
                replaced = true;
            }
        } while (replaced);
    }

    private static void increaseSQLQueryBlockRefCountForNewSQLRelations(SQLWith node, List<IXQEQueryNode> sqlRelations) {
        for (IXQEQueryNode aSQLRelationNode : sqlRelations) {
            SQLQueryBlock theQueryBlock;
            SQLRelation aSQLRelation = (SQLRelation)aSQLRelationNode;
            if (!aSQLRelation.isWithClauseQueryRef() || (theQueryBlock = node.getQueryByName(aSQLRelation.getName())) == null) continue;
            theQueryBlock.incrementReferenceCount();
        }
    }

    private static boolean isReferencedFromReusableQuery(IXQEQueryNode node, SQLRelation rNode) {
        boolean status = false;
        for (IXQEQueryNode tmp = rNode.getParent(); tmp != node; tmp = tmp.getParent()) {
            if (tmp.getType() != 301004 || ((SQLQueryBlock)tmp).getReusableQuery() == null) continue;
            status = true;
            break;
        }
        return status;
    }

    private static void updateRefCountInCommonTable(IXQEQueryNode withNode, List<IXQEQueryNode> relationNodes) {
        HashSet<SQLRelation> matchingNodes = new HashSet<SQLRelation>();
        for (int i = 0; i < withNode.getNumberChildren() - 1; ++i) {
            SQLQueryBlock qBlock = (SQLQueryBlock)withNode.getChild(i);
            String qbName = qBlock.getCorrelationName();
            if (null == qbName) continue;
            int refCount = 0;
            for (IXQEQueryNode node : relationNodes) {
                SQLRelation rNode = (SQLRelation)node;
                if (matchingNodes.contains(rNode) || !rNode.getName().equals(qbName)) continue;
                ++refCount;
                matchingNodes.add(rNode);
            }
            if (qBlock.getReferenceCount() >= refCount) continue;
            qBlock.setReferenceCount(refCount);
        }
    }
}

