/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLGroupBy;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.preoptimization.SQLPreoptimizerUtil;
import com.cognos.xqe.util.CollectionCast;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EliminateExpressionsFromGroupBy
extends RQETransformation {
    static final String DERIVED_TABLE_NAME = "D1";

    public EliminateExpressionsFromGroupBy() {
        this.mName = "Eliminate Expressions from Group By.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{301010};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        Collection<IDataSource> dataSources = pQueryBlock.getDataSourceList();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLGroupByList groupByList = ((SQLGroupBy)node).getGroupByList();
        List<IXQEQueryNode> groupByListExpr = groupByList.getProjectableExpressions();
        ArrayList<IXQEQueryNode> listOfAggrToKeepInCurrentQuery = new ArrayList<IXQEQueryNode>();
        SQLValueList projection = (SQLValueList)node.getChild(1);
        for (int i = 0; i < projection.getNumberChildren(); ++i) {
            SQLQueryNode projectedNode = (SQLQueryNode)projection.getChild(i);
            listOfAggrToKeepInCurrentQuery.addAll(this.getAggregatesToKeepInCurrentQuery(projectedNode, groupByListExpr));
        }
        ArrayList<IXQEQueryNode> derivedExpr = new ArrayList<IXQEQueryNode>();
        derivedExpr.addAll(groupByList.getProjectableExpressionsExcludingAnchorList(listOfAggrToKeepInCurrentQuery, environment));
        ArrayList<IXQEQueryNode> derivedExprFromProjections = new ArrayList<IXQEQueryNode>();
        derivedExprFromProjections.addAll(projection.getProjectableExpressionsExcludingAnchorList(listOfAggrToKeepInCurrentQuery, environment));
        block1: for (IXQEQueryNode exprNode : derivedExprFromProjections) {
            IXQEQueryNode[] fids = exprNode.getDescendantsOfTypes(new int[]{301032, 301013, 301012}, true);
            if (fids.length == 0) {
                for (IXQEQueryNode exprNodeFromGroupBy : groupByListExpr) {
                    if (!exprNode.isSameExpression(exprNodeFromGroupBy, false)) continue;
                    derivedExpr.add(exprNode);
                    continue block1;
                }
                continue;
            }
            derivedExpr.add(exprNode);
        }
        SQLQueryBlock qBlock = (SQLQueryBlock)nodeFactory.createNode(301004);
        qBlock.setName(DERIVED_TABLE_NAME);
        qBlock.setDataSourceList(dataSources);
        qBlock.setForeign(true);
        node.getChild(0).insertParent(qBlock);
        SQLProject derived = (SQLProject)nodeFactory.createNode(301015);
        qBlock.getChild(0).insertParent(derived);
        SQLValueList derivedProjection = SQLPreoptimizerUtil.buildProjection(environment, derivedExpr, 0, 0, qBlock.getDataSource());
        derived.addChild(derivedProjection);
        this.clearSupportedProperty(derivedProjection);
        ArrayList<SQLAlias> aliasList = new ArrayList<SQLAlias>();
        for (int i = 0; i < derivedProjection.getNumberChildren(); ++i) {
            SQLAlias aliasNode = (SQLAlias)nodeFactory.createNode(301028);
            aliasNode.setName("C" + i);
            aliasList.add(aliasNode);
        }
        derivedProjection.setAliasList(aliasList);
        List<SQLAlias> outerAliasList = projection.getAliasList();
        if (outerAliasList == null) {
            outerAliasList = new ArrayList<SQLAlias>(projection.getNumberChildren());
            for (int i = 0; i < projection.getNumberChildren(); ++i) {
                outerAliasList.add(null);
            }
            projection.setAliasList(outerAliasList);
        }
        for (int i = 0; i < projection.getNumberChildren(); ++i) {
            IXQEQueryNode child = projection.getChild(i);
            if (child.getType() != 301032) continue;
            SQLFid fid = (SQLFid)child;
            SQLAlias aliasNode = outerAliasList.get(i);
            if (aliasNode != null || fid.getName() == null) continue;
            aliasNode = (SQLAlias)nodeFactory.createNode(301028);
            aliasNode.setName(fid.getName());
            outerAliasList.set(fid.getColumnNo(), aliasNode);
        }
        List<SQLFid> fids = CollectionCast.downcast(projection.getDescendantsOfTypeOrdered(301032, 301004), IXQEQueryNode.class, SQLFid.class);
        for (SQLFid fid : fids) {
            fid.setName(((SQLAlias)aliasList.get(fid.getColumnNo())).getName());
            fid.setTableName(DERIVED_TABLE_NAME);
        }
        fids = CollectionCast.downcast(groupByList.getDescendantsOfTypeOrdered(301032, 301004), IXQEQueryNode.class, SQLFid.class);
        for (SQLFid fid : fids) {
            fid.setName(((SQLAlias)aliasList.get(fid.getColumnNo())).getName());
            fid.setTableName(DERIVED_TABLE_NAME);
        }
        qBlock.setQueryItemList(SQLPreoptimizerUtil.getQueryItemList(derivedProjection));
    }

    private void clearSupportedProperty(IXQEQueryNode node) {
        node.removeProperty("supported");
        for (IXQEQueryNode child : node.getChildren()) {
            this.clearSupportedProperty(child);
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<IXQEQueryNode> getAggregatesToKeepInCurrentQuery(SQLQueryNode projectionNode, List<IXQEQueryNode> groupByExpressions) {
        ArrayList<IXQEQueryNode> listOfAggrToKeepInCurrentQuery = new ArrayList<IXQEQueryNode>();
        if (projectionNode.getType() != 301032) {
            boolean isGroupExpression = false;
            for (SQLQueryNode sQLQueryNode : groupByExpressions) {
                if (!projectionNode.isSameExpression(sQLQueryNode, false)) continue;
                isGroupExpression = true;
                break;
            }
            if (!isGroupExpression) {
                void var6_8;
                IXQEQueryNode[] descendantAggrList = projectionNode.getDescendantsOfType(301034, true);
                boolean bl = false;
                while (var6_8 < descendantAggrList.length) {
                    if (!this.isAggregateFoundInGroupByList((SQLAggregate)descendantAggrList[var6_8], groupByExpressions)) {
                        listOfAggrToKeepInCurrentQuery.add(descendantAggrList[var6_8]);
                    }
                    ++var6_8;
                }
            }
        }
        return listOfAggrToKeepInCurrentQuery;
    }

    private boolean isAggregateFoundInGroupByList(SQLAggregate aggr, List<IXQEQueryNode> groupByExpressions) {
        boolean aggrIsInGroupBy = false;
        block0: for (SQLQueryNode sQLQueryNode : groupByExpressions) {
            if (sQLQueryNode.isSameExpression(aggr, false)) {
                aggrIsInGroupBy = true;
                break;
            }
            IXQEQueryNode[] ancestorList = aggr.getAncestorsOfTypeWithAnchor(sQLQueryNode.getType(), 301010);
            if (ancestorList == null) continue;
            for (int k = 0; k < ancestorList.length; ++k) {
                if (!ancestorList[k].isSameExpression(sQLQueryNode, false)) continue;
                aggrIsInGroupBy = true;
                continue block0;
            }
        }
        return aggrIsInGroupBy;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock childQueryBlock;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        if (node.getChild(0).getType() == 301004 && (childQueryBlock = (SQLQueryBlock)node.getChild(0)).getName().equals(DERIVED_TABLE_NAME)) {
            this.traceQueryCondition(false, "The transformation has been applied to the node.", trace);
            return false;
        }
        boolean status = false;
        SQLGroupByList groupByList = ((SQLGroupBy)node).getGroupByList();
        if (groupByList != null) {
            List<SQLAggregate> aggrNodes = CollectionCast.downcast(groupByList.getDescendantsOfTypeOrdered(301034, true), IXQEQueryNode.class, SQLAggregate.class);
            for (SQLAggregate aggrNode : aggrNodes) {
                if (aggrNode.isStandardAggregate()) {
                    throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidAggregateInGroupingElementList);
                }
                status = true;
            }
            if (!status) {
                IXQEQueryNode child = null;
                boolean isExpression = false;
                boolean nodeIsSupported = dataSource != null && node.isSupported(dataSource);
                boolean supportsExpressionsInGroupBy = dataSource != null && dataSource.getCapabilities().isSupported("supports.expressionsInGroupBy");
                boolean supportsSubqueryInGroupBy = dataSource != null && dataSource.getCapabilities().isSupported("supports.subqueriesInGroupBy");
                for (int i = 0; i < groupByList.getNumberChildren(); ++i) {
                    child = groupByList.getChild(i);
                    isExpression = child.getType() != 301032;
                    boolean bl = isExpression = isExpression && child.getType() != 301056 && child.getType() != 301057 && child.getType() != 301058;
                    if (!isExpression || nodeIsSupported && supportsExpressionsInGroupBy && (supportsSubqueryInGroupBy || child.getFirstDescendantOfTypeOrdered(301059, false) == null)) continue;
                    status = true;
                    break;
                }
            }
        }
        if (status) {
            this.traceQueryCondition(status, "GROUP BY specification contains expressions.", trace);
        } else {
            this.traceQueryCondition(status, "GROUP BY specification doesn't contain expressions.", trace);
        }
        return status;
    }
}

