/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLWith;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class ExtractSortFromWithClause
extends RQETransformation {
    public ExtractSortFromWithClause() {
        this.mName = "Extract the SORT node from the main query of a WITH clause.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301022};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getParent();
        SQLWith sqlWith = (SQLWith)node;
        SQLQueryNode mainQuery = (SQLQueryNode)sqlWith.getChild(sqlWith.getNumberChildren() - 1);
        IXQEQueryNode parent = qBlock.getParent();
        IXQEQueryNode child = mainQuery.getChild(0);
        mainQuery.move(parent, 0);
        if (child.getType() == 301060) {
            child = child.getChild(0).getChild(0);
        }
        child.getChild(0).move(sqlWith);
        qBlock.move(child, 0);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        IXQEQueryNode ancstr;
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLWith sqlWith = (SQLWith)node;
        IXQEQueryNode mainQuery = sqlWith.getChild(sqlWith.getNumberChildren() - 1);
        boolean bl = status = mainQuery.getType() == 301004 && (((SQLQueryBlock)mainQuery).getBlockType() == 301060 || ((SQLQueryBlock)mainQuery).getBlockType() == 301019) && !((SQLQueryBlock)mainQuery).isForeign();
        if (status && (ancstr = sqlWith.getAncestorOfType(301022)) != null) {
            status = false;
        }
        if (status) {
            this.traceQueryCondition(status, "There is a SORT node in the main query of a WITH clause.", trace);
        } else {
            this.traceQueryCondition(status, "There is no SORT node in the main query of a WITH clause.", trace);
        }
        return status;
    }
}

