/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public final class FlattenQuery
extends RQETransformation {
    public FlattenQuery() {
        this.mName = "Flatten simple query.";
        this.mPassNumbers = new int[]{6};
        this.mTypes = new int[]{301004};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        node.extract();
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = true;
        SQLQueryBlock qBlock = (SQLQueryBlock)node;
        IXQEQueryNode parent = qBlock.getParent();
        if (qBlock.getName() == null || qBlock.getReusableQuery() != null || qBlock.getDerivedColumnList() != null || parent.getType() != 301015 && parent.getType() != 301010 && parent.getType() != 301009) {
            status = false;
        } else {
            IXQEQueryNode child = node.getChild(0);
            if (child.getType() == 301015) {
                SQLValueList vList = ((SQLProject)child).getOutputList();
                for (IXQEQueryNode eNode : vList.getChildren()) {
                    if (eNode.getType() == 301032 || eNode.getType() == 301031) continue;
                    status = false;
                    break;
                }
            } else {
                status = false;
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Query can be flattened.", trace);
        } else {
            this.traceQueryCondition(status, "Query cannot be flattened.", trace);
        }
        return status;
    }
}

