/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLCast;
import com.cognos.xqe.ast.sql.SQLDataType;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueExpression;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.types.DoubleType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.util.Governors;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class GenerateCastOverExactNumericDivision
extends RQETransformation {
    public static final String FALSE = "false";
    public static final String TRUE = "true";

    public GenerateCastOverExactNumericDivision() {
        this.mName = "Generate a cast to double over Exact Numeric Division.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301025, 301034};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        GenerateCastOverExactNumericDivision.doTransformation(node, environment);
    }

    public static void doTransformation(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        SQLQueryNode dividend = (SQLQueryNode)node.getChild(0);
        SQLCast castNode = (SQLCast)factory.createNode(301047);
        SQLDataType dType = (SQLDataType)factory.createNode(301037);
        dType.setDataType(DoubleType.DOUBLETYPE);
        dividend.insertParent(castNode);
        castNode.addChild(dType);
        ((SQLQueryNode)node).invalidateSupportCache();
        castNode.setOptional(true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IDataSource dataSource = null;
        boolean status = false;
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        if (qBlock != null) {
            dataSource = qBlock.getDataSource();
        }
        if (dataSource != null && dataSource.isRelational() && (status = GenerateCastOverExactNumericDivision.optionalCastIsNeeded(node))) {
            Governors.ExactNumericDivision exactNumericDivision = node.getGovernors().getExactNumericDivision();
            switch (exactNumericDivision) {
                case CAST_TO_DOUBLE: {
                    status = true;
                    break;
                }
                case CAST_TO_DOUBLE_CONDITIONAL: {
                    if (node.getChild(0).getType() != 301047) break;
                    status = false;
                    break;
                }
                case DO_NOT_ADJUST: {
                    status = false;
                    break;
                }
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Need to compensate for exact numeric division.", trace);
        } else {
            this.traceQueryCondition(status, "Don't need to compensate for exact numeric division.", trace);
        }
        return status;
    }

    public static boolean optionalCastIsNeeded(IXQEQueryNode node) {
        boolean status = false;
        if (node.getType() == 301025 && (((SQLValueExpression)node).getSubType() == SQLValueExpression.SubType.DIVIDE || ((SQLValueExpression)node).getSubType() == SQLValueExpression.SubType.SAFE_DIVIDE)) {
            IDataType dividendDataType = ((SQLQueryNode)node.getChild(0)).getDataType();
            IDataType divisorDataType = ((SQLQueryNode)node.getChild(1)).getDataType();
            boolean dividendMatters = dividendDataType.isExactNumeric();
            boolean divisorMatters = divisorDataType.isExactNumeric();
            status = dividendMatters && divisorMatters;
        } else if (node.getType() == 301034 && ((SQLAggregate)node).getSubType() == SQLAggregate.SubType.AVG) {
            IDataType childDataType = ((SQLQueryNode)node.getChild(0)).getDataType();
            status = childDataType.isExactNumeric();
        }
        return status;
    }
}

