/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLWith;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class PushSQLWith
extends RQETransformation {
    private static final String PUSH_SQLWITH = "pushSQLWith";

    public PushSQLWith() {
        this.mName = "Push and distribute WITH clause to foreign query blocks.";
        this.mPassNumbers = new int[]{21};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mTypes = new int[]{301022};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLQueryBlock qBlock;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLWith sqlWith = (SQLWith)node;
        IXQEQueryNode mainQuery = node.getChild(node.getNumberChildren() - 1);
        IXQEQueryNode[] qBlocks = mainQuery.getDescendantsOfType(301004, false);
        for (int i = 0; i < qBlocks.length; ++i) {
            qBlock = (SQLQueryBlock)qBlocks[i];
            if (!qBlock.isForeign() || qBlock.getCorrelationName() != null) continue;
            this.makeSQLWith(sqlWith, qBlock, nodeFactory);
        }
        Queue<IXQEQueryNode> localReferences = this.getReferences(sqlWith, (SQLQueryBlock)sqlWith.getChild(node.getNumberChildren() - 1));
        if (localReferences.isEmpty()) {
            for (int i = sqlWith.getNumberChildren() - 2; i >= 0; --i) {
                SQLQueryBlock qb = (SQLQueryBlock)sqlWith.getChild(i);
                qb.detach();
            }
            SQLQueryBlock qb = (SQLQueryBlock)sqlWith.getParent();
            if (qb.getParent().getType() == 301014) {
                sqlWith.getChild(0).extract();
                sqlWith.extract();
            } else {
                sqlWith.getParent().extract();
                sqlWith.extract();
            }
        } else {
            sqlWith.setNameList(sqlWith.getNameList());
            qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
            qBlock.setPropertyValue("decomposeSQLWith", Boolean.TRUE);
        }
    }

    void makeSQLWith(SQLWith withClause, IXQEQueryNode queryBlock, IXQENodeFactory nodeFactory) {
        Queue<IXQEQueryNode> references = this.getReferences(withClause, queryBlock);
        if (references.isEmpty()) {
            return;
        }
        List<SQLQueryBlock> resultList = this.collectCTEs(withClause, references, nodeFactory);
        LinkedList<String> names = new LinkedList<String>();
        IXQEQueryNode child = queryBlock.getChild(0);
        if (child.getType() == 301019) {
            child = child.getChild(0);
        }
        SQLWith with = (SQLWith)nodeFactory.createNode(301022);
        child.insertParent(with);
        for (int i = 0; i < resultList.size(); ++i) {
            SQLQueryBlock node = resultList.get(i);
            with.addChild(node);
            names.add(node.getCorrelationName());
        }
        with.addChild(with.getChild(0).detach());
        queryBlock.setPropertyValue(PUSH_SQLWITH, Boolean.TRUE);
    }

    List<SQLQueryBlock> collectCTEs(SQLWith withClause, Queue<IXQEQueryNode> queryRefs, IXQENodeFactory nodeFactory) {
        if (queryRefs.size() == 0) {
            return null;
        }
        LinkedList<SQLQueryBlock> resultList = new LinkedList<SQLQueryBlock>();
        HashMap<String, SQLQueryBlock> collection = new HashMap<String, SQLQueryBlock>();
        while (!queryRefs.isEmpty()) {
            IXQEQueryNode ixqeQueryNode = queryRefs.remove();
            String queryName = ((SQLRelation)ixqeQueryNode).getName();
            SQLQueryBlock cte = (SQLQueryBlock)collection.get(queryName);
            if (cte != null) {
                cte.incrementReferenceCount();
                continue;
            }
            cte = withClause.getQueryByName(queryName);
            Queue<IXQEQueryNode> tmp = this.getReferences(withClause, cte);
            queryRefs.addAll(tmp);
            cte = (SQLQueryBlock)nodeFactory.deepCopyNode(cte);
            cte.setReferenceCount(1);
            collection.put(queryName, cte);
        }
        List<String> names = withClause.getNameList();
        for (String string : names) {
            SQLQueryBlock cte = (SQLQueryBlock)collection.get(string);
            if (cte == null) continue;
            resultList.add(cte);
        }
        return resultList;
    }

    Queue<IXQEQueryNode> getReferences(SQLWith withClause, IXQEQueryNode queryBlock) {
        List<IXQEQueryNode> tempList = queryBlock.getDescendantsOfTypeOrdered(301016, false);
        LinkedList<IXQEQueryNode> resultList = new LinkedList<IXQEQueryNode>();
        for (SQLRelation sQLRelation : tempList) {
            SQLWith with;
            if (!sQLRelation.isWithClauseQueryRef()) continue;
            for (with = (SQLWith)sQLRelation.getAncestorOfType(301022); with != null && null == with.getQueryByName(sQLRelation.getName()); with = (SQLWith)with.getAncestorOfType(301022)) {
            }
            if (with != withClause) continue;
            resultList.add(sQLRelation);
        }
        return resultList;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        Boolean isDecomposed;
        XQETrace trace = environment.getTrace();
        boolean status = true;
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = qBlock.getDataSource();
        if (dataSource == null || !dataSource.isRelational()) {
            status = false;
        }
        if (status) {
            boolean bl = status = !qBlock.isForeign();
        }
        if (status && (isDecomposed = qBlock.getBooleanPropertyValue("decomposeSQLWith")) != null && isDecomposed.booleanValue()) {
            status = false;
        }
        if (status) {
            this.traceQueryCondition(status, "The With clause can be pushed to foreign query blocks", trace);
        } else {
            this.traceQueryCondition(status, "The With clause cannot be pushed to foreign query blocks", trace);
        }
        return status;
    }
}

