/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;

public final class ReorderNestedJoin
extends RQETransformation {
    public ReorderNestedJoin() {
        this.mName = "Reorder a nested SQLJoin node.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{301011};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLJoin join = (SQLJoin)node;
        IXQEQueryNode parent = node.getParent();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        SQLQueryNode leftChild = (SQLQueryNode)node.getChild(0);
        SQLQueryNode rightChild = (SQLQueryNode)node.getChild(1);
        SQLQueryNode rightNode = (SQLQueryNode)parent.getChild(1);
        int leftChildColumns = leftChild.getNumberColumns();
        int rightChildColumns = rightChild.getNumberColumns();
        int rightNodeColumns = rightNode.getNumberColumns();
        SQLQueryNode nodePredicate = (SQLQueryNode)join.getPredicate();
        SQLQueryNode parentPredicate = (SQLQueryNode)((SQLJoin)parent).getPredicate();
        List<SQLFid> nodeFids = nodePredicate.getFieldIdentifiers();
        List<SQLFid> parentFids = parentPredicate.getFieldIdentifiers();
        this.adjustFIDs(leftChildColumns, 1, rightNodeColumns, nodeFids);
        this.adjustFIDs(leftChildColumns, 1, -rightChildColumns, parentFids);
        List<SQLFid> queryFids = pQueryBlock.getFieldIdentifiers();
        SQLQueryItemList qItemRightChild = rightChild.getQueryItemList();
        SQLQueryItemList qItemRightNode = rightNode.getQueryItemList();
        boolean keepSourceNo = parent.getParent().getNodeType() == 301014 || parent.getParent().getType() == 301011;
        this.adjustFIDs(qItemRightChild, qItemRightNode, keepSourceNo, queryFids);
        rightChild.detach();
        rightNode.detach();
        nodePredicate.detach();
        parentPredicate.detach();
        node.addChild(rightNode);
        node.addChild(parentPredicate);
        parent.addChild(rightChild);
        parent.addChild(nodePredicate);
        SQLJoin.SubType joinType = join.getJoinType();
        join.setJoinType(((SQLJoin)parent).getJoinType());
        ((SQLJoin)parent).setJoinType(joinType);
        SQLQueryItemList bindItems = join.getQueryItemList();
        join.setPropertyValue("queryItems", bindItems);
        while (parent.getParent().getType() == 301014 || parent.getParent().getType() == 301011) {
            bindItems = ((SQLQueryNode)parent).getQueryItemList();
            parent.setPropertyValue("queryItems", bindItems);
            parent = parent.getParent();
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        IXQEQueryNode parent = node.getParent();
        boolean bl = status = parent.getType() == 301011;
        if (status) {
            boolean bl2 = status = parent.getPositionOfChild(node) == 0;
        }
        if (status) {
            status = this.candidateForReorder((SQLJoin)node, (SQLJoin)parent);
        } else {
            this.traceQueryCondition(status, "Join node doesn't have to be decomposed.", trace);
        }
        return status;
    }

    boolean candidateForReorder(SQLJoin node, SQLJoin parent) {
        boolean status = false;
        if (node.getJoinType() == SQLJoin.SubType.RIGHT_OUTER || parent.getJoinType() == SQLJoin.SubType.RIGHT_OUTER) {
            return status;
        }
        SQLQueryNode leftChild = (SQLQueryNode)node.getChild(0);
        SQLQueryNode rightChild = (SQLQueryNode)node.getChild(1);
        SQLQueryNode rightNode = (SQLQueryNode)parent.getChild(1);
        IDataSource leftChildDS = null;
        if (leftChild.getNodeType() == 301011) {
            ArrayList<IDataSource> dsList = new ArrayList<IDataSource>();
            leftChild.getDataSourceList(dsList);
            if (dsList.size() == 1) {
                leftChildDS = dsList.get(0);
            }
        } else {
            leftChildDS = leftChild.getDataSource();
        }
        IDataSource rightChildDS = rightChild.getDataSource();
        IDataSource rightDS = rightNode.getDataSource();
        if (leftChildDS == null || rightChildDS == null || rightDS == null) {
            return status;
        }
        if (leftChildDS.getCMDataSourceName() == rightDS.getCMDataSourceName() && (leftChildDS.getCMDataSourceName() == rightChildDS.getCMDataSourceName() && !rightChild.isSupported(rightChildDS) && parent.getChild(1).isSupported(rightDS) || leftChildDS.getCMDataSourceName() != rightChildDS.getCMDataSourceName())) {
            SQLQueryNode predicate = (SQLQueryNode)parent.getPredicate();
            List<SQLFid> fids = predicate.getFieldIdentifiers();
            status = this.referencedFIDs(leftChild.getNumberColumns(), fids);
        }
        return status;
    }

    boolean referencedFIDs(int baseColumnNo, List<SQLFid> fids) {
        for (SQLFid fid : fids) {
            if (fid.getSourceNo() != 0 || fid.getVirtualColumnNo() < baseColumnNo) continue;
            return false;
        }
        return true;
    }

    void adjustFIDs(int baseCount, int sourceNo, int adjustCount, List<SQLFid> fids) {
        for (SQLFid fid : fids) {
            if (fid.getSourceNo() != sourceNo || fid.getVirtualColumnNo() < baseCount) continue;
            fid.setVirtualColumnNo(fid.getVirtualColumnNo() + adjustCount);
        }
    }

    void adjustFIDs(SQLQueryItemList qItemList1, SQLQueryItemList qItemList2, boolean keepSourceNo, List<SQLFid> fids) {
        int count1 = qItemList1.size();
        int count2 = qItemList2.size();
        for (SQLFid fid : fids) {
            if (this.adjustVirtualColumnNo(qItemList1, count2, fid)) {
                if (keepSourceNo) continue;
                fid.setSourceNo(1);
                continue;
            }
            if (!this.adjustVirtualColumnNo(qItemList2, -count1, fid) || keepSourceNo) continue;
            fid.setSourceNo(0);
        }
    }

    boolean adjustVirtualColumnNo(SQLQueryItemList qItems, int adjust, SQLFid fid) {
        for (SQLQueryItem qItem : qItems) {
            if (!qItem.getTableName().equals(fid.getTableName()) || qItem.getColumnNo() != fid.getColumnNo()) continue;
            fid.setVirtualColumnNo(fid.getVirtualColumnNo() + adjust);
            return true;
        }
        return false;
    }
}

