/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLWindow;
import com.cognos.xqe.ast.sql.SQLWindowList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import java.util.List;

public class ResolveWindowReferences
extends RQETransformation {
    public ResolveWindowReferences() {
        this.mName = "Resolve references to window list, and eliminate the window list from the project node.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301015, 301010};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLWindowList windowList = ((SQLProject)node).getWindowList();
        windowList.detach();
        List<IXQEQueryNode> windows = node.getDescendantsOfTypeOrdered(301041, 301004);
        this.resolveWindowReferences(windows, windowList, environment);
    }

    private void resolveWindowReferences(List<IXQEQueryNode> refs, SQLWindowList windowList, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        for (int i = 0; i < refs.size(); ++i) {
            Boolean resolved = false;
            SQLWindow ref = (SQLWindow)refs.get(i);
            for (int j = 0; j < windowList.getNumberChildren(); ++j) {
                SQLWindow window = (SQLWindow)windowList.getChild(j);
                if (!ref.getReferenceName().equals(window.getName())) continue;
                IXQEQueryNode refPartitionBy = ref.getPartitionBy();
                IXQEQueryNode refOrderBy = ref.getOrderBy();
                IXQEQueryNode wOrderBy = window.getOrderBy();
                String wFrameUnits = window.getWindowFrameUnits();
                if (refPartitionBy != null) {
                    throw new XQERuntimeException(XQEMessageKeys.PLN_PartitionByNotAllowed, window.getName());
                }
                if (refOrderBy != null && wOrderBy != null) {
                    throw new XQERuntimeException(XQEMessageKeys.PLN_OrderByNotAllowed, window.getName());
                }
                if ((refOrderBy != null || ref.getWindowFrameUnits() != null) && wFrameUnits != null) {
                    throw new XQERuntimeException(XQEMessageKeys.PLN_WindowFrameNotAllowed, window.getName());
                }
                IXQEQueryNode wPartitionBy = window.getPartitionBy();
                if (wPartitionBy != null) {
                    ref.addChild(nodeFactory.deepCopyNode(wPartitionBy));
                }
                if (wOrderBy != null) {
                    ref.addChild(nodeFactory.deepCopyNode(wOrderBy));
                }
                if (wFrameUnits != null) {
                    ref.setWindowFrameUnits(wFrameUnits);
                    ref.setWindowFrameLowerBound(window.getWindowFrameLowerBound());
                    ref.setWindowFrameUpperBound(window.getWindowFrameUpperBound());
                }
                ref.setReferenceName(null);
                resolved = true;
                break;
            }
            if (resolved.booleanValue()) continue;
            throw new XQERuntimeException(XQEMessageKeys.PLN_CouldNotResolveWindowRefs);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        SQLWindowList windowList = ((SQLProject)node).getWindowList();
        boolean bl = status = windowList != null && (dataSource == null || !windowList.isSupported(dataSource));
        if (status) {
            this.traceQueryCondition(status, "WINDOW LIST is present in the projection.", trace);
        } else {
            this.traceQueryCondition(status, "WINDOW LIST is not present in the projection.", trace);
        }
        return status;
    }
}

