/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLPeriodPredicate;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class RewritePeriodPredicate
extends RQETransformation {
    public RewritePeriodPredicate() {
        this.mName = "Rewrite period predicate.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301095};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLPeriodPredicate.SubType subType = ((SQLPeriodPredicate)node).getSubType();
        IXQEQueryNode period1 = node.getChild(0);
        IXQEQueryNode period2 = node.getChild(1);
        IXQEQueryNode newNode = null;
        switch (subType) {
            case OVERLAPS: {
                newNode = this.createLogicalAndNode(nodeFactory, this.createComparisonNode(nodeFactory, SQLComparison.SubType.LESS, period1.getChild(0), period2.getChild(1)), this.createComparisonNode(nodeFactory, SQLComparison.SubType.GREATER, period1.getChild(1), period2.getChild(0)));
                break;
            }
            case EQUALS: {
                newNode = this.createLogicalAndNode(nodeFactory, this.createComparisonNode(nodeFactory, SQLComparison.SubType.EQUAL, period1.getChild(0), period2.getChild(0)), this.createComparisonNode(nodeFactory, SQLComparison.SubType.EQUAL, period1.getChild(1), period2.getChild(1)));
                break;
            }
            case CONTAINS: {
                newNode = this.createLogicalAndNode(nodeFactory, this.createComparisonNode(nodeFactory, SQLComparison.SubType.LESSEQUAL, period1.getChild(0), period2.getChild(0)), this.createComparisonNode(nodeFactory, SQLComparison.SubType.GREATEREQUAL, period1.getChild(1), period2.getChild(1)));
                break;
            }
            case IMMEDIATELY_PRECEDES: {
                newNode = this.createLogicalAndNode(nodeFactory, this.createLogicalAndNode(nodeFactory, this.createIsNotNullNode(nodeFactory, period1.getChild(0)), this.createIsNotNullNode(nodeFactory, period2.getChild(1))), this.createComparisonNode(nodeFactory, SQLComparison.SubType.EQUAL, period1.getChild(1), period2.getChild(0)));
                break;
            }
            case IMMEDIATELY_SUCCEEDS: {
                newNode = this.createLogicalAndNode(nodeFactory, this.createLogicalAndNode(nodeFactory, this.createIsNotNullNode(nodeFactory, period1.getChild(1)), this.createIsNotNullNode(nodeFactory, period2.getChild(0))), this.createComparisonNode(nodeFactory, SQLComparison.SubType.EQUAL, period1.getChild(0), period2.getChild(1)));
                break;
            }
            case PRECEDES: {
                newNode = this.createLogicalAndNode(nodeFactory, this.createLogicalAndNode(nodeFactory, this.createIsNotNullNode(nodeFactory, period1.getChild(0)), this.createIsNotNullNode(nodeFactory, period2.getChild(1))), this.createComparisonNode(nodeFactory, SQLComparison.SubType.LESSEQUAL, period1.getChild(1), period2.getChild(0)));
                break;
            }
            case SUCCEEDS: {
                newNode = this.createLogicalAndNode(nodeFactory, this.createLogicalAndNode(nodeFactory, this.createIsNotNullNode(nodeFactory, period1.getChild(1)), this.createIsNotNullNode(nodeFactory, period2.getChild(0))), this.createComparisonNode(nodeFactory, SQLComparison.SubType.GREATEREQUAL, period1.getChild(0), period2.getChild(1)));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        node.exchange(newNode, false);
    }

    private IXQEQueryNode createLogicalAndNode(IXQENodeFactory nodeFactory, IXQEQueryNode leftChild, IXQEQueryNode rightChild) {
        SQLLogical logicalExpr = (SQLLogical)nodeFactory.createNode(301027);
        logicalExpr.setSubType(SQLLogical.SubType.AND);
        logicalExpr.addChild(leftChild);
        logicalExpr.addChild(rightChild);
        return logicalExpr;
    }

    private IXQEQueryNode createComparisonNode(IXQENodeFactory nodeFactory, SQLComparison.SubType subType, IXQEQueryNode leftChild, IXQEQueryNode rightChild) {
        SQLComparison cExpr = (SQLComparison)nodeFactory.createNode(301026);
        cExpr.setSubType(subType);
        cExpr.addChild(leftChild);
        cExpr.addChild(rightChild);
        return cExpr;
    }

    private IXQEQueryNode createIsNotNullNode(IXQENodeFactory nodeFactory, IXQEQueryNode child) {
        IXQEQueryNode isNullNode = nodeFactory.createNode(301024);
        isNullNode.addChild(child);
        SQLLogical logicalExpr = (SQLLogical)nodeFactory.createNode(301027);
        logicalExpr.setSubType(SQLLogical.SubType.NOT);
        logicalExpr.addChild(isNullNode);
        return logicalExpr;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock pQueryBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = pQueryBlock.getDataSource();
        IXQEQueryNode period1 = node.getChild(0);
        IXQEQueryNode period2 = node.getChild(1);
        boolean bl = status = dataSource != null && period1.getType() == 301079 && period2.getType() == 301079 && !node.isSupported(dataSource);
        if (status) {
            this.traceQueryCondition(status, "The period predicate must be rewritten.", trace);
        } else {
            this.traceQueryCondition(status, "The period predicate does not need to be rewritten.", trace);
        }
        return status;
    }
}

