/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLSubQuery;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import com.cognos.xqe.transformation.relational.optimization.util.FactorAnalyzer;
import com.cognos.xqe.transformation.relational.optimization.util.JoinGraph;
import com.cognos.xqe.transformation.relational.optimization.util.JoinMatrix;
import com.cognos.xqe.transformation.relational.preoptimization.SQLPreoptimizerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class RewriteProductAsJoinedTable
extends RQETransformation {
    public RewriteProductAsJoinedTable() {
        this(18);
    }

    public RewriteProductAsJoinedTable(int passNumber) {
        this.mName = "Convert product to joined table.";
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{301014};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        int i;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        int nSources = node.getNumberChildren();
        List<IXQEQueryNode> leafNodes = SQLPreoptimizerUtil.getLeafNodes(node);
        ArrayList<SQLFilter> ejFactorList = new ArrayList<SQLFilter>();
        ArrayList<SQLFilter> factorList = new ArrayList<SQLFilter>();
        IXQEQueryNode parent = node.getParent();
        while (parent.getType() == 301009) {
            SQLFilter factor = (SQLFilter)parent;
            if (factor.getFactorType() == FactorAnalyzer.FactorType.EQUIJOIN) {
                ejFactorList.add(0, factor);
            }
            factorList.add(0, factor);
            parent = parent.getParent();
        }
        JoinMatrix jMatrix = new JoinMatrix(nSources, ejFactorList);
        List<JoinGraph> joinGraphs = jMatrix.enumerateJoinGraphs();
        IXQEQueryNode[] children = node.getChildren();
        BitMask sourcesUsed = new BitMask();
        int[] joinOrder = new int[nSources];
        int sourceNo = 0;
        for (JoinGraph jGraph : joinGraphs) {
            List<JoinGraph.Vertex> nodes = jGraph.getNodes();
            jGraph.applyDijkstraAlgorithm(nodes.get(0));
            XQEBaseQueryNode jNode = null;
            for (i = 1; i < nodes.size(); ++i) {
                LinkedList<JoinGraph.Vertex> path = jGraph.getShortestPath(nodes.get(i));
                if (path == null || path.isEmpty()) continue;
                int lSourceNo = nodes.get(0).getSourceNo();
                for (int j = 1; j < path.size(); ++j) {
                    JoinGraph.Vertex v = (JoinGraph.Vertex)path.get(j);
                    int rSourceNo = v.getSourceNo();
                    if (sourcesUsed.get(rSourceNo)) {
                        lSourceNo = rSourceNo;
                        continue;
                    }
                    sourcesUsed.set(rSourceNo);
                    SQLJoin joinNode = (SQLJoin)nodeFactory.createNode(301011);
                    joinNode.setJoinType(SQLJoin.SubType.INNER);
                    if (jNode == null) {
                        joinNode.addChild(children[lSourceNo].detach());
                        node.addChild(joinNode, 0);
                        joinOrder[sourceNo++] = lSourceNo;
                    } else {
                        jNode.insertParent(joinNode);
                    }
                    jNode = joinNode;
                    joinNode.addChild(children[rSourceNo].detach());
                    joinOrder[sourceNo++] = rSourceNo;
                    IXQEQueryNode predicate = null;
                    Iterator fIterator = factorList.iterator();
                    while (fIterator.hasNext()) {
                        SQLFilter factor = (SQLFilter)fIterator.next();
                        BitMask incidence = factor.getIncidence();
                        if (!incidence.get(lSourceNo) || !incidence.get(rSourceNo)) continue;
                        if (predicate == null) {
                            predicate = factor.getPredicate().detach();
                        } else {
                            SQLLogical logicalNode = (SQLLogical)nodeFactory.createNode(301027);
                            logicalNode.setSubType(SQLLogical.SubType.AND);
                            logicalNode.addChild(predicate);
                            logicalNode.addChild(factor.getPredicate().detach());
                            predicate = logicalNode;
                        }
                        factor.extract();
                        fIterator.remove();
                    }
                    joinNode.addChild(predicate);
                    lSourceNo = rSourceNo;
                }
            }
        }
        children = node.getChildren();
        IXQEQueryNode root = children[0].detach();
        for (int i2 = 1; i2 < children.length; ++i2) {
            SQLJoin joinNode = (SQLJoin)nodeFactory.createNode(301011);
            joinNode.setJoinType(SQLJoin.SubType.CROSS);
            joinNode.addChild(root);
            joinNode.addChild(children[i2].detach());
            root = joinNode;
        }
        List<IXQEQueryNode> reorderedLeafNodes = SQLPreoptimizerUtil.getLeafNodes(root);
        nSources = reorderedLeafNodes.size();
        int[] offsets = new int[nSources];
        offsets[0] = 0;
        int offset = 0;
        for (i = 1; i < nSources; ++i) {
            offsets[i] = offset += ((SQLQueryNode)reorderedLeafNodes.get(i - 1)).getNumberColumns();
        }
        for (SQLFilter factor : factorList) {
            IXQEQueryNode[] fids = factor.getPredicate().getDescendantsOfType(301032, false, 301059);
            for (int i3 = 0; i3 < fids.length; ++i3) {
                SQLFid fid = (SQLFid)fids[i3];
                IXQEQueryNode leafNode = leafNodes.get(fid.getSourceNo());
                sourceNo = reorderedLeafNodes.indexOf(leafNode);
                fid.setVirtualColumnNo(fid.getColumnNo() + offsets[sourceNo]);
            }
        }
        node.exchange(root);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IXQEQueryNode parent = node.getParent();
        int nSources = node.getNumberChildren();
        boolean status = false;
        if (qBlock.isForeign() && (environment.isBigSQL() || qBlock.getDataSource().getCapabilities().isSupported("supports.rewriteImplicitCrossJoins"))) {
            for (IXQEQueryNode child : node.getChildren()) {
                if (child.getType() != 301011) continue;
                status = true;
                break;
            }
            if (!status) {
                ArrayList<SQLFilter> factorList = new ArrayList<SQLFilter>();
                while (parent.getType() == 301009) {
                    SQLFilter factor = (SQLFilter)parent;
                    SQLExpression predicate = factor.getPredicate();
                    IXQEQueryNode[] subQueries = predicate.getDescendantsOfType(301059, false, 301004);
                    if (subQueries.length > 0 && ((SQLSubQuery)subQueries[0]).rewriteAsJoin()) {
                        IXQEQueryNode subQuery = subQueries[0];
                        boolean bl = status = (subQuery.getParent().getType() == 301076 || subQuery.getParent().getType() == 301054) && subQuery.getGrandParent().getType() == 301027 && ((SQLLogical)subQuery.getGrandParent()).getSubType() == SQLLogical.SubType.NOT;
                        if (status) break;
                    }
                    if (factor.getFactorType() == FactorAnalyzer.FactorType.EQUIJOIN) {
                        factorList.add(0, (SQLFilter)parent);
                    }
                    parent = parent.getParent();
                }
                if (!status) {
                    if (factorList.size() == 0) {
                        status = true;
                    } else {
                        BitMask jIncidence = new BitMask();
                        boolean lastTime = false;
                        do {
                            lastTime = factorList.size() <= 1;
                            Iterator fIterator = factorList.iterator();
                            while (fIterator.hasNext()) {
                                BitMask incidence = ((SQLFilter)fIterator.next()).getIncidence();
                                if (jIncidence.isEmpty()) {
                                    jIncidence.set(incidence);
                                }
                                if (jIncidence.land(incidence).isEmpty()) continue;
                                jIncidence.or(incidence);
                                fIterator.remove();
                            }
                        } while (!lastTime);
                        boolean bl = status = jIncidence.cardinality() != nSources;
                    }
                }
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Product needs to be converted to a joined table.", trace);
        } else {
            this.traceQueryCondition(status, "Product does not need to be converted to a joined table.", trace);
        }
        return status;
    }
}

