/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLGroupBy;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLWindow;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.preoptimization.SQLPreoptimizerUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class RewriteUnsupportedWindowedCountDistinct
extends RQETransformation {
    public RewriteUnsupportedWindowedCountDistinct() {
        this.mName = "Rewrite unsupported window count distinct.";
        this.mPassNumbers = new int[]{1};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mTypes = new int[]{301010};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        int i;
        SQLQueryBlock rootQBlock = (SQLQueryBlock)node.getParent();
        Collection<IDataSource> dataSources = rootQBlock.getDataSourceList();
        IXQEQueryNode relationQBlock = node.getChild(0);
        XQENodeFactory factory = environment.getNodeFactory();
        SQLQueryBlock qBlock = (SQLQueryBlock)factory.createNode(301004);
        qBlock.setForeign(true);
        qBlock.setDataSourceList(dataSources);
        qBlock.setName("D");
        SQLGroupBy derivedTab = (SQLGroupBy)factory.createNode(301010);
        relationQBlock.move(derivedTab);
        qBlock.addChild(derivedTab);
        node.addChild(qBlock, 0);
        IXQEQueryNode vl = factory.createNode(301030);
        derivedTab.addChild(vl);
        IXQEQueryNode gbl = factory.createNode(301029);
        derivedTab.addChild(gbl);
        ArrayList<SQLAlias> aliasList = new ArrayList<SQLAlias>();
        ((SQLValueList)vl).setAliasList(aliasList);
        SQLValueList vList = ((SQLGroupBy)node).getValueList();
        IXQEQueryNode[] fids = vList.getChildrenOfType(301032);
        IXQEQueryNode[] aggrs = vList.getDescendantsOfType(301034, false);
        for (i = 0; i < fids.length; ++i) {
            SQLFid fidToMoveToDerivedTab = (SQLFid)fids[i];
            SQLFid fidToStayInOuterQuery = (SQLFid)factory.deepCopyNode(fidToMoveToDerivedTab);
            fidToStayInOuterQuery.setTableName(qBlock.getName());
            fidToStayInOuterQuery.setColumnNo(derivedTab.getValueList().getNumberChildren());
            fidToStayInOuterQuery.setVirtualColumnNo(fidToStayInOuterQuery.getColumnNo());
            fidToMoveToDerivedTab.exchange(fidToStayInOuterQuery);
            String aliasName = "C".concat(String.valueOf(derivedTab.getValueList().getChildren().length));
            fidToStayInOuterQuery.setName(aliasName);
            RewriteUnsupportedWindowedCountDistinct.moveFidToDerivedTable(aliasName, fidToMoveToDerivedTab, derivedTab, factory);
        }
        for (i = 0; i < aggrs.length; ++i) {
            SQLAggregate aggr = (SQLAggregate)aggrs[i];
            SQLWindow childWin = (SQLWindow)aggr.getFirstChildByType(301041);
            SQLAggregate sum = (SQLAggregate)factory.createNode(301034);
            sum.setSubType(SQLAggregate.SubType.SUM);
            SQLFid fidForSum = (SQLFid)factory.deepCopyNode(aggr.getChild(0));
            sum.addChild(fidForSum);
            childWin.move(sum);
            aggr.exchange(sum);
            String aliasName = "C".concat(String.valueOf(derivedTab.getValueList().getChildren().length));
            fidForSum.setName(aliasName);
            RewriteUnsupportedWindowedCountDistinct.moveAggrToDerivedTable(aliasName, aggr, derivedTab, factory);
            fidForSum.setTableName(qBlock.getName());
            fidForSum.setName(aliasName);
            RewriteUnsupportedWindowedCountDistinct.updateFidProperties(fidForSum, (SQLValueList)vl);
        }
        RewriteUnsupportedWindowedCountDistinct.setQueryItemList(qBlock, (SQLValueList)vl);
        ((SQLGroupBy)node).getGroupByList().detach();
        IXQEQueryNode project = factory.createNode(301015);
        rootQBlock.exchangeChildNode(node, project, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        IXQEQueryNode[] fids;
        IXQEQueryNode[] aggrs;
        boolean status = false;
        SQLValueList vList = ((SQLGroupBy)node).getValueList();
        for (IXQEQueryNode aggr : aggrs = vList.getDescendantsOfType(301034, false)) {
            status = RewriteUnsupportedWindowedCountDistinct.isUnsupportedWindowedCountDistinct(aggr);
            if (status) continue;
            return status;
        }
        if (!status) {
            return status;
        }
        for (IXQEQueryNode fid : fids = vList.getDescendantsOfType(301032, false)) {
            if (fid.getParent().getType() == 301030 || fid.getParent().getType() == 301034) continue;
            status = false;
            break;
        }
        return status;
    }

    private static boolean isUnsupportedWindowedCountDistinct(IXQEQueryNode node) {
        IXQEQueryNode sqlWindow;
        boolean result = false;
        SQLAggregate aggr = (SQLAggregate)node;
        if (aggr.getSubType() == SQLAggregate.SubType.COUNT && aggr.isDistinct() && aggr.isWindowedAggregate()) {
            result = true;
        }
        if (result && (sqlWindow = aggr.getFirstChildByType(301041)).getNumberChildren() != 0) {
            result = false;
        }
        if (result) {
            SQLFid firstOperand = (SQLFid)aggr.getFirstChildByType(301032);
            SQLValueList projectionList = (SQLValueList)aggr.getAncestorOfType(301030);
            IXQEQueryNode[] projs = projectionList.getChildrenOfType(301032);
            boolean isGroupingColumn = false;
            for (IXQEQueryNode proj : projs) {
                if (!firstOperand.getName().equals(((SQLFid)proj).getName())) continue;
                isGroupingColumn = true;
                break;
            }
            if (!isGroupingColumn) {
                result = false;
            }
        }
        if (result) {
            SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
            IDataSource dataSource = null;
            if (qBlock != null) {
                dataSource = qBlock.getDataSource();
            } else {
                result = false;
            }
            if (result && dataSource != null) {
                result &= !aggr.isSupported(dataSource);
            }
        }
        return result;
    }

    private static void moveFidToDerivedTable(String aliasName, SQLFid fid, SQLGroupBy dTable, IXQENodeFactory factory) {
        SQLValueList vList = dTable.getValueList();
        SQLGroupByList gbList = dTable.getGroupByList();
        vList.addChild(fid);
        gbList.addChild(factory.deepCopyNode(fid));
        SQLAlias alias = (SQLAlias)factory.createNode(301028);
        alias.setName(aliasName);
        vList.getAliasList().add(alias);
    }

    private static void moveAggrToDerivedTable(String aliasName, SQLAggregate aggr, SQLGroupBy dTable, IXQENodeFactory factory) {
        SQLValueList vList = dTable.getValueList();
        vList.addChild(aggr);
        SQLAlias alias = (SQLAlias)factory.createNode(301028);
        alias.setName(aliasName);
        vList.getAliasList().add(alias);
    }

    private static void setQueryItemList(SQLQueryBlock qBlock, SQLValueList vl) {
        qBlock.setQueryItemList(SQLPreoptimizerUtil.getQueryItemList(vl));
        List<SQLAlias> aliasList = vl.getAliasList();
        SQLQueryItemList qiList = qBlock.getQueryItemList();
        for (int i = 0; i < aliasList.size(); ++i) {
            SQLQueryItem qi = (SQLQueryItem)qiList.get(i);
            if (qi.getName() != null) continue;
            qi.setName(aliasList.get(i).getName());
        }
    }

    private static void updateFidProperties(SQLFid fid, SQLValueList vList) {
        List<SQLAlias> aList = vList.getAliasList();
        for (int i = 0; i < aList.size(); ++i) {
            if (!fid.getName().equals(aList.get(i).getName())) continue;
            fid.setColumnNo(i);
            fid.setVirtualColumnNo(i);
            break;
        }
    }
}

