/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.preoptimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLValueExpression;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class SimplifyValueExpressions
extends RQETransformation {
    public SimplifyValueExpressions() {
        this.mName = "Simplify value expressions.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{301025};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        SQLValueExpression vExpr = (SQLValueExpression)node;
        SQLValueExpression.SubType subType = vExpr.getSubType();
        if (subType == SQLValueExpression.SubType.UNARYPLUS) {
            vExpr.extract();
        } else {
            SQLExpression lChild = (SQLExpression)vExpr.getChild(0).detach();
            SQLExpression rChild = (SQLExpression)vExpr.getChild(0).detach();
            switch (subType) {
                case ADD: 
                case SUBTRACT: {
                    if (lChild.isIntegerLiteralValueZero()) {
                        vExpr.exchange(rChild);
                        if (subType != SQLValueExpression.SubType.SUBTRACT) break;
                        SQLValueExpression vExpr2 = (SQLValueExpression)factory.createNode(301025);
                        vExpr2.setSubType(SQLValueExpression.SubType.NEGATE);
                        rChild.insertParent(vExpr2);
                        break;
                    }
                    vExpr.exchange(lChild);
                    break;
                }
                case MULTIPLY: {
                    if (lChild.isIntegerLiteralValueZero() || rChild.isIntegerLiteralValueOne()) {
                        vExpr.exchange(lChild);
                        break;
                    }
                    vExpr.exchange(rChild);
                    break;
                }
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        SQLValueExpression vExpr = (SQLValueExpression)node;
        SQLValueExpression.SubType subType = vExpr.getSubType();
        boolean status = false;
        if (subType == SQLValueExpression.SubType.UNARYPLUS) {
            status = true;
        } else if (vExpr.getNumberChildren() == 2 && vExpr.getDescendantsOfType(301059, false).length == 0) {
            SQLExpression lChild = (SQLExpression)vExpr.getChild(0);
            SQLExpression rChild = (SQLExpression)vExpr.getChild(1);
            boolean bl = status = (subType == SQLValueExpression.SubType.ADD || subType == SQLValueExpression.SubType.SUBTRACT) && (lChild.isIntegerLiteralValueZero() || rChild.isIntegerLiteralValueZero()) || subType == SQLValueExpression.SubType.MULTIPLY && (lChild.isIntegerLiteralValueOne() || rChild.isIntegerLiteralValueOne() || (lChild.isIntegerLiteralValueZero() || rChild.isIntegerLiteralValueZero()) && !lChild.isNullable() && !rChild.isNullable());
        }
        if (status) {
            this.traceQueryCondition(status, "Value expression can be simplified.", trace);
        } else {
            this.traceQueryCondition(status, "Value expression cannot be simplified.", trace);
        }
        return status;
    }
}

