/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLValueExpression;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.NullValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import com.cognos.xqe.util.Governors;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.Collection;

public class FoldConstants
extends RQETransformation {
    public static final String PROP_BOOLEAN_FOLDING_APPLIED = "foldingApplied";
    public static final String PROP_BOOLEAN_PREOPTIMIZER_FOLDING_APPLIED = "preOptimizerFoldingApplied";

    public FoldConstants() {
        this.mName = "FoldConstants.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
        this.initialize();
    }

    protected void initialize() {
        this.mPassNumbers = new int[]{5, 15};
        this.mTypes = new int[]{301026, 301045, 301063, 301033, 301076, 301027, 301079, 301064, 301044, 301025, 301071, 301072, 301077, 301075};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        XDataContext context = new XDataContext(null, (IExecutionEnvironment)environment.getExecutionEnvironment());
        try {
            Value value = (Value)((SQLExpression)node).execute(context);
            if (value == null) {
                return;
            }
            SQLLiteral literal = (SQLLiteral)factory.createNode(301031);
            if (value.isNull() && node.getType() == 301033 && ((SQLFunction)node).getSubType() == SQLFunction.SubType.JSON_VALUE) {
                NullValue nullValue = DataValueFactory.createNullValue();
                literal.setValue(nullValue);
            } else {
                literal.setValue(value);
            }
            node.exchange(literal, false);
        }
        catch (Exception exception) {
        }
        finally {
            node.setPropertyValue(PROP_BOOLEAN_PREOPTIMIZER_FOLDING_APPLIED, Boolean.TRUE);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        boolean localProcessing = qBlock == null || !qBlock.isForeign();
        Governors governors = node.getGovernors();
        boolean bl = status = (governors == null || governors.getConstantFolding() != false) && node.getPropertyValue(PROP_BOOLEAN_FOLDING_APPLIED) != Boolean.TRUE && node.getPropertyValue(PROP_BOOLEAN_PREOPTIMIZER_FOLDING_APPLIED) != Boolean.TRUE && ((SQLExpression)node).isExecutable(localProcessing) && !this.integerDivisionOnDecFloat(node, environment);
        if (status) {
            this.traceQueryCondition(status, "Constant folding can be performed.", trace);
        } else {
            this.traceQueryCondition(status, "Constant folding cannot be performed.", trace);
        }
        return status;
    }

    private boolean integerDivisionOnDecFloat(IXQEQueryNode node, IPlanningEnvironment environment) {
        IDataType[] operDataTypes;
        if (!(node instanceof SQLValueExpression)) {
            return false;
        }
        if (((SQLValueExpression)node).getSubType() == SQLValueExpression.SubType.DIVIDE && (operDataTypes = ((SQLValueExpression)node).getParameterTypes()).length == 2 && operDataTypes[0].isInteger() && operDataTypes[1].isInteger()) {
            IDataSource theDataSource = null;
            Collection<IDataSource> dataSources = SQLBinderUtil.getDataSources(environment.getRequestEnvironment(), node);
            for (IDataSource dataSource : dataSources) {
                if (dataSource == null || !dataSource.isRelational()) continue;
                theDataSource = dataSource;
                break;
            }
            if (null != theDataSource && theDataSource.getDataSourceConnection().getConnectionString().toLowerCase().contains("ibmcognos.decfloat=true")) {
                return true;
            }
        }
        return false;
    }
}

