/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.util.FoldConstants;
import com.cognos.xqe.util.Governors;

public class FoldConstantsForLocalProcessing
extends FoldConstants {
    private static final String PROP_BOOLEAN_OPTIMIZER_FOLDING_APPLIED = "optimizerFoldingApplied";

    @Override
    protected void initialize() {
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{301047, 301026, 301045, 301063, 301033, 301076, 301027, 301079, 301064, 301044, 301025, 301071, 301072};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        super.apply(node, environment);
        node.setPropertyValue(PROP_BOOLEAN_OPTIMIZER_FOLDING_APPLIED, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        boolean localProcessing = qBlock == null || !qBlock.isForeign();
        Governors governors = node.getGovernors();
        boolean bl = status = localProcessing && (governors == null || governors.getConstantFolding() != false) && node.getPropertyValue("foldingApplied") != Boolean.TRUE && node.getPropertyValue(PROP_BOOLEAN_OPTIMIZER_FOLDING_APPLIED) != Boolean.TRUE && ((SQLExpression)node).isExecutable(localProcessing);
        if (status) {
            this.traceQueryCondition(status, "Constant folding can be performed.", trace);
        } else {
            this.traceQueryCondition(status, "Constant folding cannot be performed.", trace);
        }
        return status;
    }
}

