/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.relational.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLSort;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class RQEUtil {
    public static final String PROP_NOCACHE = "noCache";

    public static void transferNoCache(IXQEQueryNode src, IXQEQueryNode tar) {
        Object b = src.getPropertyValue(PROP_NOCACHE);
        if (b != null) {
            tar.setPropertyValue(PROP_NOCACHE, b);
        }
    }

    public static void transferNoCacheToDescendants(IXQEQueryNode src) {
        Boolean b = (Boolean)src.getPropertyValue(PROP_NOCACHE);
        if (Boolean.TRUE.equals(b)) {
            IXQEQueryNode[] lst;
            int[] types = new int[]{301004, 301007};
            for (IXQEQueryNode n : lst = src.getDescendantsOfTypes(types, false)) {
                n.setPropertyValue(PROP_NOCACHE, Boolean.TRUE);
            }
        }
    }

    public static boolean hasNoCacheObjects(IXQEQueryNode node, int[] types) {
        IXQEQueryNode[] vars;
        for (IXQEQueryNode v : vars = node.getDescendantsOfTypes(types, true)) {
            Boolean b = (Boolean)v.getPropertyValue(PROP_NOCACHE);
            if (!Boolean.TRUE.equals(b)) continue;
            return true;
        }
        return false;
    }

    public static void convertRelationIntoDerivedTable(SQLQueryBlock qBlock, String qBlockName, XQENodeFactory factory) {
        IXQEQueryNode parent = qBlock.getParent();
        while (parent.getChildrenOfType(301030).length == 0) {
            parent = parent.getParent();
        }
        SQLSortKeyList sortList = null;
        if (parent.getParent().getType() == 301019) {
            sortList = ((SQLSort)parent.getParent()).getSortKeyList();
        }
        List<IXQEQueryNode> ids = parent.getDescendantsOfTypeOrdered(301032, false);
        HashSet<String> refIdNames = new HashSet<String>();
        for (IXQEQueryNode id : ids) {
            SQLFid fid = (SQLFid)id;
            if (!qBlockName.equals(fid.getTableName())) continue;
            refIdNames.add(fid.getName());
        }
        SQLQueryItemList queryItemList = qBlock.getQueryItemList();
        Iterator iter = queryItemList.iterator();
        while (iter.hasNext()) {
            SQLQueryItem item = (SQLQueryItem)iter.next();
            if (refIdNames.contains(item.getName())) continue;
            iter.remove();
        }
        SQLRelation relation = (SQLRelation)qBlock.getChild(0);
        SQLProject project = (SQLProject)factory.createNode(301015);
        SQLRangeVar rangeVar = (SQLRangeVar)factory.createNode(301007);
        rangeVar.setName(relation.getName());
        SQLValueList valueList = (SQLValueList)factory.createNode(301030);
        project.addChild(rangeVar);
        project.addChild(valueList);
        qBlock.exchangeChildNode(relation, project);
        relation.insertParent(rangeVar);
        int numOfItemsInList = queryItemList.size();
        ArrayList<SQLFid> idsWithUpdatedColumnNo = new ArrayList<SQLFid>();
        for (int i = 0; i < numOfItemsInList; ++i) {
            SQLQueryItem qItem = (SQLQueryItem)queryItemList.get(i);
            SQLFid proj = (SQLFid)factory.createNode(301032);
            proj.setName(qItem.getName());
            proj.setTableName(rangeVar.getName());
            valueList.addChild(proj);
            for (IXQEQueryNode id : ids) {
                SQLFid fid = (SQLFid)id;
                if (idsWithUpdatedColumnNo.contains(fid) || !fid.getTableName().equals(qBlockName) || !fid.getName().equals(proj.getName())) continue;
                fid.setColumnNo(i);
                fid.setVirtualColumnNo(i);
                idsWithUpdatedColumnNo.add(fid);
            }
            if (sortList == null) continue;
            List<IXQEQueryNode> sortKeys = sortList.getDescendantsOfTypeOrdered(301032, false);
            for (IXQEQueryNode s : sortKeys) {
                SQLFid key = (SQLFid)s;
                if (!key.getName().equals(proj.getName())) continue;
                key.setColumnNo(i);
                key.setVirtualColumnNo(i);
            }
        }
    }
}

