/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.rolap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundMultiPartIdentifier;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.Metadata;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.olap.XMdx;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.querytemplates.CustomQuery;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.List;
import java.util.Locale;

public final class ROLAPUtilities {
    public static final String ROLAP_DATASOURCE_TYPE = "RO";

    private ROLAPUtilities() {
    }

    public static boolean isQueryROLAP(IXQEQueryNode queryNode) {
        XMdxLocal xmdxLocal;
        IXQEQueryNode root = null;
        switch (queryNode.getType()) {
            case 501053: {
                XMdxLocal xmdxLocal2 = (XMdxLocal)queryNode;
                return xmdxLocal2.getDataSource() == null || xmdxLocal2.getDataSource().getType().equalsIgnoreCase(ROLAP_DATASOURCE_TYPE);
            }
            case 101006: {
                V5Query v5Query;
                root = v5Query = (V5Query)queryNode;
                break;
            }
        }
        if (root == null) {
            V5Query v5Query = (V5Query)queryNode.getAncestorOfType(101006);
            RSAPIDataset rsapiDataset = (RSAPIDataset)queryNode.getAncestorOfType(401005);
            root = v5Query != null ? v5Query : (rsapiDataset != null ? rsapiDataset : queryNode.getAncestorOfType(1101013));
            boolean isCustomQuery = false;
            if (queryNode.isOfCategory(501017)) {
                XMdx xMDXQuery = (XMdx)queryNode;
                isCustomQuery = xMDXQuery.getMDXQuery() instanceof CustomQuery;
            }
            if (root == null && !isCustomQuery) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Neither v5Query, rsapiDataset nor MARequest node were found");
            }
        }
        if (root != null && (xmdxLocal = (XMdxLocal)root.getAncestorOfType(501053)) == null) {
            for (IXQEQueryNode node : root.getDescendantsOfType(501053, true)) {
                xmdxLocal = (XMdxLocal)node;
                if (xmdxLocal.getDataSource() != null && !xmdxLocal.getDataSource().getType().equalsIgnoreCase(ROLAP_DATASOURCE_TYPE)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isQueryVirtualCube(PlanningEnvironment environment) {
        MetadataConnection mc = environment.getMetadataConnection();
        if (mc == null) {
            return false;
        }
        String cubeUniqueName = mc.getCubes()[0].getUniqueName();
        ROLAPCube rolapCube = ROLAPCubeManager.getInstance().getCube(cubeUniqueName);
        return rolapCube.isVirtual();
    }

    public static boolean isQueryROLAP(IPlanningEnvironment environment) {
        MetadataConnection mc = (MetadataConnection)environment.getMetadataConnection();
        if (mc == null) {
            return false;
        }
        List<IModelDataSource> ds = mc.getModelDataSources();
        for (IModelDataSource datasource : ds) {
            if (!datasource.isROLAP()) continue;
            return true;
        }
        return false;
    }

    public static boolean isQueryROLAP(IXQEQueryNode queryNode, PlanningEnvironment environment) {
        List<IModelDataSource> modelDataSources = environment.getMetadataConnection().getModelDataSources();
        int rolapDataSourceCount = 0;
        int dmrDataSourceCount = 0;
        for (IModelDataSource ds : modelDataSources) {
            if (ds.isROLAP()) {
                ++rolapDataSourceCount;
                continue;
            }
            if (!ds.isRelational() || ds.getCube() == null) continue;
            ++dmrDataSourceCount;
        }
        if (rolapDataSourceCount == modelDataSources.size()) {
            return true;
        }
        if (dmrDataSourceCount == modelDataSources.size()) {
            return false;
        }
        IXQEQueryNode[] nodes = queryNode.getDescendantsOfType(201116, true);
        if (!(nodes != null && nodes.length != 0 || (nodes = queryNode.getDescendantsOfType(201117, true)) != null && nodes.length != 0)) {
            return false;
        }
        for (IXQEQueryNode node : nodes) {
            V5BoundMultiPartIdentifier identifier = (V5BoundMultiPartIdentifier)node;
            IMetadata metadata = identifier.getMetadata();
            if (metadata == null || !MetadataType.isROLAP(metadata)) continue;
            return true;
        }
        return false;
    }

    public static String getExpressionLocale(Metadata md) {
        String locale = null;
        Object reqEnv = ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment();
        if (reqEnv.getUseDesignLocaleForExpressions() && md != null && md.getConnection() != null) {
            locale = md.getConnection().getDefaultLocaleString();
        }
        if (locale == null || locale.isEmpty()) {
            Locale expressionLocale = reqEnv.getExpressionLocale();
            locale = LocaleConverter.localeToStr(expressionLocale);
        }
        return locale;
    }
}

