/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.rsapi;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.rsapi.RSAPIUtilities;
import com.cognos.xqe.util.Governors;

public class AddRSAPIDataset
extends Transformation {
    public AddRSAPIDataset() {
        this.mName = "Add RS API Dataset to QRD.";
        this.mPassNumbers = new int[1];
        this.mPassNumbers[0] = 0;
        this.mTypes = new int[1];
        this.mTypes[0] = 101055;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        int[] types;
        boolean status = false;
        XQETrace trace = environment.getTrace();
        IXQEQueryNode parent = node.getParent();
        if (!parent.isOfTypes(types = new int[]{401005, 101006, 601026})) {
            status = true;
        } else if (parent.getType() == 101006 && !((V5Query)parent).isTabular() && Boolean.TRUE != parent.getBooleanPropertyValue("forceDMRtoRQP")) {
            status = true;
        }
        if (status) {
            this.traceNodeCondition(status, "No RS API dataset has been assigned to the QRD yet.", trace);
        } else {
            this.traceNodeCondition(status, "An RS API dataset has already been assigned to the QRD.", trace);
        }
        return status;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode sqlQuery;
        IXQEQueryNode source;
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)node;
        RSAPIDataset dataset = (RSAPIDataset)environment.getNodeFactory().createNode(401005);
        dataset.setReturnDataItemNameInPartialDataset(environment);
        if (v5QRD.getPropertyValue("isDetailQuery") != null) {
            dataset.setForDetailQuery(true);
        }
        dataset.setName((String)v5QRD.getPropertyValue("name"));
        if (v5QRD.getOriginalRefQueryProperty() != null) {
            dataset.setOriginalRefQueryName(v5QRD.getOriginalRefQueryProperty());
        }
        dataset.setRefQueryName((String)v5QRD.getPropertyValue("refQuery"));
        dataset.setIncludeEmptyCells(((RequestEnvironment)environment.getRequestEnvironment()).getIncludeEmptyCells());
        v5QRD.insertParent(dataset);
        environment.getNodeIndex().addNode(dataset);
        V5Query v5Query = RSAPIUtilities.findQueryAssociatedWithDataset(dataset);
        Integer xMdxNodeId = (Integer)v5Query.getPropertyValue("xmdxNodeId");
        if (xMdxNodeId != null) {
            dataset.setXmdxNodeId(xMdxNodeId);
        }
        if ((source = v5Query.getFirstChildByType(101007)) != null && (sqlQuery = source.getFirstChildByType(101016)) != null) {
            dataset.setForSqlQuery(true);
        }
        boolean associatedQueryIsDMR = v5Query.isDMR();
        dataset.setForDMRReport(associatedQueryIsDMR);
        Governors governors = null;
        Object govProperty = v5QRD.getPropertyValue("governors");
        governors = govProperty != null ? (Governors)govProperty : (Governors)v5Query.getPropertyValue("governors");
        dataset.setGovernors(governors);
        dataset.setQueryFeedbacks(v5QRD.getQueryFeedbacks());
        Governors.ExecutionOptimization optimization = governors.getExecutionOptimization();
        if (!optimization.equals((Object)Governors.ExecutionOptimization.ALLROWS)) {
            dataset.setOptimizeForAllRows(false);
        } else {
            dataset.setOptimizeForAllRows(true);
        }
        dataset.setUseSAPMUNAsBusinessKey(governors.getUseSAPMUNAsBusinessKey());
        dataset.setTransferMembers(v5QRD.getBooleanPropertyValue("transferMembers", false));
    }
}

