/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.rsapi;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.rsapi.RSAPIUtilities;

public class AddRSAPIRowsetToValueset
extends Transformation {
    public AddRSAPIRowsetToValueset() {
        this.mName = "Add RS API Rowset to various valueset nodes.";
        this.mPassNumbers = new int[1];
        this.mPassNumbers[0] = 0;
        this.mTypes = new int[1];
        this.mTypes[0] = 101057;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode outerSiblingValueSet;
        RSAPIEdgeRowset outerSiblingRowset;
        XQETrace trace = environment.getTrace();
        RSAPIRowset rowset = (RSAPIRowset)node.getPropertyValue("RSAPIEdgeRowset");
        if (rowset != null) {
            this.traceNodeCondition(false, "An RS API rowset has already been assigned to the node.", trace);
            return false;
        }
        IXQEQueryNode edge = node.getAncestorOfType(101049);
        if (edge == null || edge.getPropertyValue("RSAPIEdge") == null) {
            this.traceNodeCondition(false, "The valueset does not have a parent edge or No RS API edge has been assigned!", trace);
            return false;
        }
        IXQEQueryNode parent = node.getParent();
        IXQEQueryNode edgeGroupParent = parent.getParent();
        if (parent.getType() != 101050 || edgeGroupParent == null) {
            this.traceNodeCondition(false, "The valueset does not have a parent edge group.", trace);
            return false;
        }
        IXQEQueryNode[] siblings = parent.getChildrenOfTypeOrdered(101057);
        for (int i = 0; i < siblings.length && siblings[i] != node; ++i) {
            if (siblings[i].getPropertyValue("RSAPIEdgeRowset") != null) continue;
            this.traceNodeCondition(false, "Prior sibling value sets have not been assigned rowsets.", trace);
            return false;
        }
        IXQEQueryNode[] edgeGroupSiblingValueSets = edgeGroupParent.getChildrenOfType(101057);
        if (edgeGroupSiblingValueSets.length > 0 && (outerSiblingRowset = (RSAPIEdgeRowset)(outerSiblingValueSet = edgeGroupSiblingValueSets[edgeGroupSiblingValueSets.length - 1]).getPropertyValue("RSAPIEdgeRowset")) == null) {
            this.traceNodeCondition(false, "The outer nested value set has not been assigned a rowset.", trace);
            return false;
        }
        this.traceNodeCondition(true, "No RS API rowset has been assigned to the value set node yet.", trace);
        return true;
    }

    private void checkRowsetIsNotNestedWithinMultipleValuesets(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode edgeGroup = node.getAncestorOfType(101050);
        IXQEQueryNode edgeGroupParent = edgeGroup.getAncestorOfType(101050);
        if (edgeGroupParent == null) {
            return;
        }
        int numChildValuesets = edgeGroupParent.getNumberChildrenOfType(101057);
        if (numChildValuesets > 1) {
            int aSeverity = 1;
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.RSA_GroupBodyNestedWithinMultipleValueSets));
        }
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RSAPIEdgeRowset rowset = new RSAPIEdgeRowset();
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        Boolean bNoDataMode = v5QuerySet.getBooleanPropertyValue(V5QuerySet.RequestHint.NO_DATA_MODE.getPropertyName());
        if (null != bNoDataMode) {
            rowset.setNoDataMode(bNoDataMode);
        }
        V5ValueSet v5ValueSet = (V5ValueSet)node;
        v5ValueSet.setRSAPIEdgeRowset(rowset);
        rowset.setName((String)v5ValueSet.getPropertyValue("name"));
        IXQEQueryNode edge = v5ValueSet.getAncestorOfType(101049);
        RSAPIEdge rsapiEdge = (RSAPIEdge)edge.getPropertyValue("RSAPIEdge");
        rowset.setEdge(rsapiEdge);
        rowset.setRowsetId(rsapiEdge.getNextRowsetId());
        this.addRefDataItemToRowset(v5ValueSet, environment);
        RSAPIUtilities.addPropertiesToRowset(v5ValueSet, environment, 1);
        rsapiEdge.addRowset(rowset);
        if (!this.isSiblingRowset(v5ValueSet, rowset)) {
            this.checkRowsetIsNotNestedWithinMultipleValuesets(v5ValueSet, environment);
            this.isNestedRowset(v5ValueSet, rowset, rsapiEdge);
        }
    }

    private boolean isSiblingRowset(IXQEQueryNode node, RSAPIEdgeRowset rowset) {
        IXQEQueryNode priorEdgeGroup;
        IXQEQueryNode[] valueSets;
        IXQEQueryNode parent = node.getParent();
        int position = parent.getPositionOfChild(node);
        if (position > 0) {
            IXQEQueryNode priorSibling = parent.getChild(position - 1);
            RSAPIEdgeRowset priorSiblingRowset = (RSAPIEdgeRowset)priorSibling.getPropertyValue("RSAPIEdgeRowset");
            priorSiblingRowset.setSiblingRowset(rowset);
            rowset.setParentRowset(priorSiblingRowset.getParentRowset());
            return true;
        }
        IXQEQueryNode grandparent = parent.getParent();
        position = grandparent.getPositionOfChild(parent);
        if (position > 0 && (valueSets = (priorEdgeGroup = grandparent.getChild(position - 1)).getChildrenOfType(101057)).length > 0) {
            IXQEQueryNode lastValueSet = valueSets[valueSets.length - 1];
            RSAPIEdgeRowset lastRowset = (RSAPIEdgeRowset)lastValueSet.getPropertyValue("RSAPIEdgeRowset");
            lastRowset.setSiblingRowset(rowset);
            rowset.setParentRowset(lastRowset.getParentRowset());
            return true;
        }
        return false;
    }

    private void isNestedRowset(IXQEQueryNode node, RSAPIEdgeRowset rowset, RSAPIEdge rsapiEdge) {
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() == 101050) {
            IXQEQueryNode[] edgeGroupSiblingValueSets;
            IXQEQueryNode edgeGroupParent = parent.getParent();
            for (IXQEQueryNode outerSiblingValueSet : edgeGroupSiblingValueSets = edgeGroupParent.getChildrenOfType(101057)) {
                RSAPIEdgeRowset outerSiblingRowset = (RSAPIEdgeRowset)outerSiblingValueSet.getPropertyValue("RSAPIEdgeRowset");
                if (outerSiblingRowset.getNestedRowset() == null) {
                    outerSiblingRowset.setNestedRowset(rowset);
                }
                if (rowset.getParentRowset() != null) continue;
                rowset.setParentRowset(outerSiblingRowset);
            }
            if (edgeGroupParent.getType() == 101049) {
                rsapiEdge.setRootRowset(rowset);
            }
        }
    }

    void addRefDataItemToRowset(V5ValueSet node, PlanningEnvironment environment) {
        RSAPIEdgeRowset rowset = (RSAPIEdgeRowset)node.getPropertyValue("RSAPIEdgeRowset");
        String name = (String)node.getPropertyValue("refDataItem");
        if (name != null) {
            V5Query v5Query = RSAPIUtilities.findAssociatedQuery(node);
            V5Selection v5Selection = v5Query.getV5Selection();
            V5QueryResultDefinition qrdRoot = (V5QueryResultDefinition)node.getAncestorOfType(101055);
            RSAPIDataItem dataitem = RSAPIUtilities.transferV5DataItemToRSAPIDataItem(name, v5Selection, qrdRoot.isList());
            dataitem.setUseModelLabelsForIndirectModelRefs(v5Query.getUseModelLabelsForIndirectModelRefs());
            rowset.setRefDataItem(dataitem);
            node.setRSAPIDataItem(dataitem);
        }
    }
}

