/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.rsapi;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class AdjustDataItemTypes
extends Transformation {
    public AdjustDataItemTypes() {
        this.mName = "Adjust cross tab ref data item data types.";
        this.mPassNumbers = new int[1];
        this.mPassNumbers[0] = 1;
        this.mTypes = new int[1];
        this.mTypes[0] = 401005;
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        RSAPIDataset dataset = (RSAPIDataset)node;
        if (dataset.isInvalidReport()) {
            this.traceNodeCondition(false, "The report layout has not yet been validated.", trace);
            return false;
        }
        if (!dataset.getDataTypesAdjusted()) {
            this.traceNodeCondition(true, "No attempt has been made to adjust data item types.", trace);
            return true;
        }
        this.traceNodeCondition(true, "Data item data types have already been adjusted.", trace);
        return false;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RSAPIDataset dataset = (RSAPIDataset)node;
        dataset.adjustDataItemTypes();
        environment.setTreeHasBeenModified();
    }
}

